# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DigitalTwinAdapterPayload(object):
    """
    Reference payload structure template received from IoT device. This payload
    must specify its content type using the `dataFormat` property.
    """

    #: A constant which can be used with the data_format property of a DigitalTwinAdapterPayload.
    #: This constant has a value of "JSON"
    DATA_FORMAT_JSON = "JSON"

    def __init__(self, **kwargs):
        """
        Initializes a new DigitalTwinAdapterPayload object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.iot.models.DigitalTwinAdapterJsonPayload`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_format:
            The value to assign to the data_format property of this DigitalTwinAdapterPayload.
            Allowed values for this property are: "JSON", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type data_format: str

        """
        self.swagger_types = {
            'data_format': 'str'
        }
        self.attribute_map = {
            'data_format': 'dataFormat'
        }
        self._data_format = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['dataFormat']

        if type == 'JSON':
            return 'DigitalTwinAdapterJsonPayload'
        else:
            return 'DigitalTwinAdapterPayload'

    @property
    def data_format(self):
        """
        **[Required]** Gets the data_format of this DigitalTwinAdapterPayload.
        Data format of the payload.

        Allowed values for this property are: "JSON", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The data_format of this DigitalTwinAdapterPayload.
        :rtype: str
        """
        return self._data_format

    @data_format.setter
    def data_format(self, data_format):
        """
        Sets the data_format of this DigitalTwinAdapterPayload.
        Data format of the payload.


        :param data_format: The data_format of this DigitalTwinAdapterPayload.
        :type: str
        """
        allowed_values = ["JSON"]
        if not value_allowed_none_or_none_sentinel(data_format, allowed_values):
            data_format = 'UNKNOWN_ENUM_VALUE'
        self._data_format = data_format

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
