# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531

from .configure_iot_domain_data_access_details import ConfigureIotDomainDataAccessDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DirectDataAccessDetails(ConfigureIotDomainDataAccessDetails):
    """
    This contains configuration for direct data access.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DirectDataAccessDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.iot.models.DirectDataAccessDetails.type` attribute
        of this class is ``DIRECT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this DirectDataAccessDetails.
            Allowed values for this property are: "DIRECT", "ORDS", "APEX"
        :type type: str

        :param db_allow_listed_identity_group_names:
            The value to assign to the db_allow_listed_identity_group_names property of this DirectDataAccessDetails.
        :type db_allow_listed_identity_group_names: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'db_allow_listed_identity_group_names': 'list[str]'
        }
        self.attribute_map = {
            'type': 'type',
            'db_allow_listed_identity_group_names': 'dbAllowListedIdentityGroupNames'
        }
        self._type = None
        self._db_allow_listed_identity_group_names = None
        self._type = 'DIRECT'

    @property
    def db_allow_listed_identity_group_names(self):
        """
        **[Required]** Gets the db_allow_listed_identity_group_names of this DirectDataAccessDetails.
        List of IAM groups of form described in `here`__ that are allowed to directly connect to the data host.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/mnqmn/#GUID-3634D6C9-A7F1-4875-9925-BAEA2D3C5197


        :return: The db_allow_listed_identity_group_names of this DirectDataAccessDetails.
        :rtype: list[str]
        """
        return self._db_allow_listed_identity_group_names

    @db_allow_listed_identity_group_names.setter
    def db_allow_listed_identity_group_names(self, db_allow_listed_identity_group_names):
        """
        Sets the db_allow_listed_identity_group_names of this DirectDataAccessDetails.
        List of IAM groups of form described in `here`__ that are allowed to directly connect to the data host.

        __ https://docs.oracle.com/en/cloud/paas/autonomous-database/dedicated/mnqmn/#GUID-3634D6C9-A7F1-4875-9925-BAEA2D3C5197


        :param db_allow_listed_identity_group_names: The db_allow_listed_identity_group_names of this DirectDataAccessDetails.
        :type: list[str]
        """
        self._db_allow_listed_identity_group_names = db_allow_listed_identity_group_names

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
