# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InvokeRawCommandDetails(object):
    """
    Definition of unstructured command invocation payload
    """

    #: A constant which can be used with the request_data_format property of a InvokeRawCommandDetails.
    #: This constant has a value of "TEXT"
    REQUEST_DATA_FORMAT_TEXT = "TEXT"

    #: A constant which can be used with the request_data_format property of a InvokeRawCommandDetails.
    #: This constant has a value of "JSON"
    REQUEST_DATA_FORMAT_JSON = "JSON"

    #: A constant which can be used with the request_data_format property of a InvokeRawCommandDetails.
    #: This constant has a value of "BINARY"
    REQUEST_DATA_FORMAT_BINARY = "BINARY"

    def __init__(self, **kwargs):
        """
        Initializes a new InvokeRawCommandDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.iot.models.InvokeRawBinaryCommandDetails`
        * :class:`~oci.iot.models.InvokeRawTextCommandDetails`
        * :class:`~oci.iot.models.InvokeRawJsonCommandDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param request_duration:
            The value to assign to the request_duration property of this InvokeRawCommandDetails.
        :type request_duration: str

        :param response_duration:
            The value to assign to the response_duration property of this InvokeRawCommandDetails.
        :type response_duration: str

        :param request_endpoint:
            The value to assign to the request_endpoint property of this InvokeRawCommandDetails.
        :type request_endpoint: str

        :param response_endpoint:
            The value to assign to the response_endpoint property of this InvokeRawCommandDetails.
        :type response_endpoint: str

        :param request_data_format:
            The value to assign to the request_data_format property of this InvokeRawCommandDetails.
            Allowed values for this property are: "TEXT", "JSON", "BINARY"
        :type request_data_format: str

        """
        self.swagger_types = {
            'request_duration': 'str',
            'response_duration': 'str',
            'request_endpoint': 'str',
            'response_endpoint': 'str',
            'request_data_format': 'str'
        }
        self.attribute_map = {
            'request_duration': 'requestDuration',
            'response_duration': 'responseDuration',
            'request_endpoint': 'requestEndpoint',
            'response_endpoint': 'responseEndpoint',
            'request_data_format': 'requestDataFormat'
        }
        self._request_duration = None
        self._response_duration = None
        self._request_endpoint = None
        self._response_endpoint = None
        self._request_data_format = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['requestDataFormat']

        if type == 'BINARY':
            return 'InvokeRawBinaryCommandDetails'

        if type == 'TEXT':
            return 'InvokeRawTextCommandDetails'

        if type == 'JSON':
            return 'InvokeRawJsonCommandDetails'
        else:
            return 'InvokeRawCommandDetails'

    @property
    def request_duration(self):
        """
        Gets the request_duration of this InvokeRawCommandDetails.
        Specified duration by which to send the request by.


        :return: The request_duration of this InvokeRawCommandDetails.
        :rtype: str
        """
        return self._request_duration

    @request_duration.setter
    def request_duration(self, request_duration):
        """
        Sets the request_duration of this InvokeRawCommandDetails.
        Specified duration by which to send the request by.


        :param request_duration: The request_duration of this InvokeRawCommandDetails.
        :type: str
        """
        self._request_duration = request_duration

    @property
    def response_duration(self):
        """
        Gets the response_duration of this InvokeRawCommandDetails.
        Specified duration by which to receive the response by.


        :return: The response_duration of this InvokeRawCommandDetails.
        :rtype: str
        """
        return self._response_duration

    @response_duration.setter
    def response_duration(self, response_duration):
        """
        Sets the response_duration of this InvokeRawCommandDetails.
        Specified duration by which to receive the response by.


        :param response_duration: The response_duration of this InvokeRawCommandDetails.
        :type: str
        """
        self._response_duration = response_duration

    @property
    def request_endpoint(self):
        """
        **[Required]** Gets the request_endpoint of this InvokeRawCommandDetails.
        Device endpoint where request should be forwarded to.


        :return: The request_endpoint of this InvokeRawCommandDetails.
        :rtype: str
        """
        return self._request_endpoint

    @request_endpoint.setter
    def request_endpoint(self, request_endpoint):
        """
        Sets the request_endpoint of this InvokeRawCommandDetails.
        Device endpoint where request should be forwarded to.


        :param request_endpoint: The request_endpoint of this InvokeRawCommandDetails.
        :type: str
        """
        self._request_endpoint = request_endpoint

    @property
    def response_endpoint(self):
        """
        Gets the response_endpoint of this InvokeRawCommandDetails.
        Device endpoint from which response is expected to come.


        :return: The response_endpoint of this InvokeRawCommandDetails.
        :rtype: str
        """
        return self._response_endpoint

    @response_endpoint.setter
    def response_endpoint(self, response_endpoint):
        """
        Sets the response_endpoint of this InvokeRawCommandDetails.
        Device endpoint from which response is expected to come.


        :param response_endpoint: The response_endpoint of this InvokeRawCommandDetails.
        :type: str
        """
        self._response_endpoint = response_endpoint

    @property
    def request_data_format(self):
        """
        **[Required]** Gets the request_data_format of this InvokeRawCommandDetails.
        data format: json, binary, text

        Allowed values for this property are: "TEXT", "JSON", "BINARY"


        :return: The request_data_format of this InvokeRawCommandDetails.
        :rtype: str
        """
        return self._request_data_format

    @request_data_format.setter
    def request_data_format(self, request_data_format):
        """
        Sets the request_data_format of this InvokeRawCommandDetails.
        data format: json, binary, text


        :param request_data_format: The request_data_format of this InvokeRawCommandDetails.
        :type: str
        """
        allowed_values = ["TEXT", "JSON", "BINARY"]
        if not value_allowed_none_or_none_sentinel(request_data_format, allowed_values):
            raise ValueError(
                f"Invalid value for `request_data_format`, must be None or one of {allowed_values}"
            )
        self._request_data_format = request_data_format

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
