# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HsmClusterSummary(object):
    """
    An object which encapsulates the details of a given HSM Cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HsmClusterSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this HsmClusterSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this HsmClusterSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HsmClusterSummary.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HsmClusterSummary.
        :type lifecycle_state: str

        :param dns_name:
            The value to assign to the dns_name property of this HsmClusterSummary.
        :type dns_name: str

        :param time_created:
            The value to assign to the time_created property of this HsmClusterSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this HsmClusterSummary.
        :type time_updated: datetime

        :param time_of_deletion:
            The value to assign to the time_of_deletion property of this HsmClusterSummary.
        :type time_of_deletion: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this HsmClusterSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this HsmClusterSummary.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'dns_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_of_deletion': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'dns_name': 'dnsName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_of_deletion': 'timeOfDeletion',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._dns_name = None
        self._time_created = None
        self._time_updated = None
        self._time_of_deletion = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this HsmClusterSummary.
        The OCID of a HSMCluster resource.


        :return: The id of this HsmClusterSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this HsmClusterSummary.
        The OCID of a HSMCluster resource.


        :param id: The id of this HsmClusterSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this HsmClusterSummary.
        A user-friendly name for a HSMCluster resource. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.


        :return: The display_name of this HsmClusterSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this HsmClusterSummary.
        A user-friendly name for a HSMCluster resource. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this HsmClusterSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HsmClusterSummary.
        The OCID of the compartment that contains a particular HSMCluster resource.


        :return: The compartment_id of this HsmClusterSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HsmClusterSummary.
        The OCID of the compartment that contains a particular HSMCluster resource.


        :param compartment_id: The compartment_id of this HsmClusterSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this HsmClusterSummary.
        A HSMCluster resource's current lifecycle state.

        Example: `ACTIVE`


        :return: The lifecycle_state of this HsmClusterSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HsmClusterSummary.
        A HSMCluster resource's current lifecycle state.

        Example: `ACTIVE`


        :param lifecycle_state: The lifecycle_state of this HsmClusterSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def dns_name(self):
        """
        **[Required]** Gets the dns_name of this HsmClusterSummary.
        DNS name for the HSMCluster -- this will contain information about the region as well.


        :return: The dns_name of this HsmClusterSummary.
        :rtype: str
        """
        return self._dns_name

    @dns_name.setter
    def dns_name(self, dns_name):
        """
        Sets the dns_name of this HsmClusterSummary.
        DNS name for the HSMCluster -- this will contain information about the region as well.


        :param dns_name: The dns_name of this HsmClusterSummary.
        :type: str
        """
        self._dns_name = dns_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this HsmClusterSummary.
        The date and time a dedicated KMS resource was created, expressed in `RFC 3339`__ timestamp format.

        Example: `2023-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this HsmClusterSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this HsmClusterSummary.
        The date and time a dedicated KMS resource was created, expressed in `RFC 3339`__ timestamp format.

        Example: `2023-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this HsmClusterSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this HsmClusterSummary.
        The date and time a dedicated KMS resource was updated, expressed in `RFC 3339`__ timestamp format.

        Example: `2023-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this HsmClusterSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this HsmClusterSummary.
        The date and time a dedicated KMS resource was updated, expressed in `RFC 3339`__ timestamp format.

        Example: `2023-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this HsmClusterSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_of_deletion(self):
        """
        Gets the time_of_deletion of this HsmClusterSummary.
        An optional property indicating when to delete the resource, expressed in `RFC 3339`__ timestamp format.
        Example: `2019-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_of_deletion of this HsmClusterSummary.
        :rtype: datetime
        """
        return self._time_of_deletion

    @time_of_deletion.setter
    def time_of_deletion(self, time_of_deletion):
        """
        Sets the time_of_deletion of this HsmClusterSummary.
        An optional property indicating when to delete the resource, expressed in `RFC 3339`__ timestamp format.
        Example: `2019-04-03T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_of_deletion: The time_of_deletion of this HsmClusterSummary.
        :type: datetime
        """
        self._time_of_deletion = time_of_deletion

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this HsmClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this HsmClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this HsmClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this HsmClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this HsmClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this HsmClusterSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this HsmClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this HsmClusterSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
