# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170115


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReservedIP(object):
    """
    ReservedIP model.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ReservedIP object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ReservedIP.
        :type id: str

        """
        self.swagger_types = {
            'id': 'str'
        }
        self.attribute_map = {
            'id': 'id'
        }
        self._id = None

    @property
    def id(self):
        """
        Gets the id of this ReservedIP.
        Ocid of the Reserved IP/Public Ip created with VCN.

        Reserved IPs are IPs which already registered using VCN API.

        Create a reserved Public IP and then while creating the load balancer pass the ocid of the reserved IP in this
        field reservedIp to attach the Ip to Load balancer. Load balancer will be configured to listen to traffic on this IP.

        Reserved IPs will not be deleted when the Load balancer is deleted. They will be unattached from the Load balancer.

        Example: \"ocid1.publicip.oc1.phx.unique_ID\"

        IPV6 example: \"ocid1.ipv6.oc1.phx.unique_ID\"


        :return: The id of this ReservedIP.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ReservedIP.
        Ocid of the Reserved IP/Public Ip created with VCN.

        Reserved IPs are IPs which already registered using VCN API.

        Create a reserved Public IP and then while creating the load balancer pass the ocid of the reserved IP in this
        field reservedIp to attach the Ip to Load balancer. Load balancer will be configured to listen to traffic on this IP.

        Reserved IPs will not be deleted when the Load balancer is deleted. They will be unattached from the Load balancer.

        Example: \"ocid1.publicip.oc1.phx.unique_ID\"

        IPV6 example: \"ocid1.ipv6.oc1.phx.unique_ID\"


        :param id: The id of this ReservedIP.
        :type: str
        """
        self._id = id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
