# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidateEndpointResult(object):
    """
    The result of the endpoint configuration validation
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ValidateEndpointResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param status:
            The value to assign to the status property of this ValidateEndpointResult.
        :type status: str

        :param status_description:
            The value to assign to the status_description property of this ValidateEndpointResult.
        :type status_description: str

        :param validation_results:
            The value to assign to the validation_results property of this ValidateEndpointResult.
        :type validation_results: list[oci.log_analytics.models.EndpointResult]

        """
        self.swagger_types = {
            'status': 'str',
            'status_description': 'str',
            'validation_results': 'list[EndpointResult]'
        }
        self.attribute_map = {
            'status': 'status',
            'status_description': 'statusDescription',
            'validation_results': 'validationResults'
        }
        self._status = None
        self._status_description = None
        self._validation_results = None

    @property
    def status(self):
        """
        **[Required]** Gets the status of this ValidateEndpointResult.
        The validation status.


        :return: The status of this ValidateEndpointResult.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ValidateEndpointResult.
        The validation status.


        :param status: The status of this ValidateEndpointResult.
        :type: str
        """
        self._status = status

    @property
    def status_description(self):
        """
        Gets the status_description of this ValidateEndpointResult.
        The validation status description.


        :return: The status_description of this ValidateEndpointResult.
        :rtype: str
        """
        return self._status_description

    @status_description.setter
    def status_description(self, status_description):
        """
        Sets the status_description of this ValidateEndpointResult.
        The validation status description.


        :param status_description: The status_description of this ValidateEndpointResult.
        :type: str
        """
        self._status_description = status_description

    @property
    def validation_results(self):
        """
        Gets the validation_results of this ValidateEndpointResult.
        Validation results for each specified endpoint.


        :return: The validation_results of this ValidateEndpointResult.
        :rtype: list[oci.log_analytics.models.EndpointResult]
        """
        return self._validation_results

    @validation_results.setter
    def validation_results(self, validation_results):
        """
        Sets the validation_results of this ValidateEndpointResult.
        Validation results for each specified endpoint.


        :param validation_results: The validation_results of this ValidateEndpointResult.
        :type: list[oci.log_analytics.models.EndpointResult]
        """
        self._validation_results = validation_results

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
