# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageLink(object):
    """
    Object Storage links create the relationship between a directory in an File Storage with Lustre file system and a path within an Object Storage bucket.
    For more information, see `Syncing Lustre file systems with Object Storage`__.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/lustre/object-storage-sync.htm
    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a ObjectStorageLink.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ObjectStorageLink.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ObjectStorageLink.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ObjectStorageLink.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ObjectStorageLink.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageLink object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ObjectStorageLink.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ObjectStorageLink.
        :type compartment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this ObjectStorageLink.
        :type availability_domain: str

        :param display_name:
            The value to assign to the display_name property of this ObjectStorageLink.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this ObjectStorageLink.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ObjectStorageLink.
        :type time_updated: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ObjectStorageLink.
            Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ObjectStorageLink.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ObjectStorageLink.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ObjectStorageLink.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ObjectStorageLink.
        :type system_tags: dict(str, dict(str, object))

        :param lustre_file_system_id:
            The value to assign to the lustre_file_system_id property of this ObjectStorageLink.
        :type lustre_file_system_id: str

        :param file_system_path:
            The value to assign to the file_system_path property of this ObjectStorageLink.
        :type file_system_path: str

        :param object_storage_prefix:
            The value to assign to the object_storage_prefix property of this ObjectStorageLink.
        :type object_storage_prefix: str

        :param current_job_id:
            The value to assign to the current_job_id property of this ObjectStorageLink.
        :type current_job_id: str

        :param last_job_id:
            The value to assign to the last_job_id property of this ObjectStorageLink.
        :type last_job_id: str

        :param is_overwrite:
            The value to assign to the is_overwrite property of this ObjectStorageLink.
        :type is_overwrite: bool

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'availability_domain': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'lustre_file_system_id': 'str',
            'file_system_path': 'str',
            'object_storage_prefix': 'str',
            'current_job_id': 'str',
            'last_job_id': 'str',
            'is_overwrite': 'bool'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'availability_domain': 'availabilityDomain',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lustre_file_system_id': 'lustreFileSystemId',
            'file_system_path': 'fileSystemPath',
            'object_storage_prefix': 'objectStoragePrefix',
            'current_job_id': 'currentJobId',
            'last_job_id': 'lastJobId',
            'is_overwrite': 'isOverwrite'
        }
        self._id = None
        self._compartment_id = None
        self._availability_domain = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lustre_file_system_id = None
        self._file_system_path = None
        self._object_storage_prefix = None
        self._current_job_id = None
        self._last_job_id = None
        self._is_overwrite = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ObjectStorageLink.
        The `OCID`__ of the ObjectStorageLink.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ObjectStorageLink.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ObjectStorageLink.
        The `OCID`__ of the ObjectStorageLink.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ObjectStorageLink.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ObjectStorageLink.
        The `OCID`__ of the compartment that contains the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ObjectStorageLink.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ObjectStorageLink.
        The `OCID`__ of the compartment that contains the Lustre file system.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ObjectStorageLink.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this ObjectStorageLink.
        The availability domain the file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :return: The availability_domain of this ObjectStorageLink.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this ObjectStorageLink.
        The availability domain the file system is in. May be unset
        as a blank or NULL value.

        Example: `Uocm:PHX-AD-1`


        :param availability_domain: The availability_domain of this ObjectStorageLink.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ObjectStorageLink.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Object Storage Link`


        :return: The display_name of this ObjectStorageLink.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ObjectStorageLink.
        A user-friendly name. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `My Object Storage Link`


        :param display_name: The display_name of this ObjectStorageLink.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ObjectStorageLink.
        The date and time the Lustre file system was created, expressed
        in `RFC 3339`__ timestamp format.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this ObjectStorageLink.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ObjectStorageLink.
        The date and time the Lustre file system was created, expressed
        in `RFC 3339`__ timestamp format.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this ObjectStorageLink.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ObjectStorageLink.
        The date and time the Object Storage link was updated, in the format defined by `RFC 3339`__.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ObjectStorageLink.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ObjectStorageLink.
        The date and time the Object Storage link was updated, in the format defined by `RFC 3339`__.

        Example: `2024-04-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ObjectStorageLink.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ObjectStorageLink.
        The current state of the Object Storage link.

        Allowed values for this property are: "CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ObjectStorageLink.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ObjectStorageLink.
        The current state of the Object Storage link.


        :param lifecycle_state: The lifecycle_state of this ObjectStorageLink.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ObjectStorageLink.
        A message that describes the current state of the Object Storage link in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this ObjectStorageLink.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ObjectStorageLink.
        A message that describes the current state of the Object Storage link in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this ObjectStorageLink.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this ObjectStorageLink.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ObjectStorageLink.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ObjectStorageLink.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ObjectStorageLink.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this ObjectStorageLink.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ObjectStorageLink.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ObjectStorageLink.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ObjectStorageLink.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this ObjectStorageLink.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ObjectStorageLink.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ObjectStorageLink.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ObjectStorageLink.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def lustre_file_system_id(self):
        """
        **[Required]** Gets the lustre_file_system_id of this ObjectStorageLink.
        The `OCID`__ of the associated Lustre file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The lustre_file_system_id of this ObjectStorageLink.
        :rtype: str
        """
        return self._lustre_file_system_id

    @lustre_file_system_id.setter
    def lustre_file_system_id(self, lustre_file_system_id):
        """
        Sets the lustre_file_system_id of this ObjectStorageLink.
        The `OCID`__ of the associated Lustre file system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param lustre_file_system_id: The lustre_file_system_id of this ObjectStorageLink.
        :type: str
        """
        self._lustre_file_system_id = lustre_file_system_id

    @property
    def file_system_path(self):
        """
        **[Required]** Gets the file_system_path of this ObjectStorageLink.
        The path in the Lustre file system used for this Object Storage link.

        Example: `myFileSystem/mount/myDirectory`


        :return: The file_system_path of this ObjectStorageLink.
        :rtype: str
        """
        return self._file_system_path

    @file_system_path.setter
    def file_system_path(self, file_system_path):
        """
        Sets the file_system_path of this ObjectStorageLink.
        The path in the Lustre file system used for this Object Storage link.

        Example: `myFileSystem/mount/myDirectory`


        :param file_system_path: The file_system_path of this ObjectStorageLink.
        :type: str
        """
        self._file_system_path = file_system_path

    @property
    def object_storage_prefix(self):
        """
        **[Required]** Gets the object_storage_prefix of this ObjectStorageLink.
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.

        Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`


        :return: The object_storage_prefix of this ObjectStorageLink.
        :rtype: str
        """
        return self._object_storage_prefix

    @object_storage_prefix.setter
    def object_storage_prefix(self, object_storage_prefix):
        """
        Sets the object_storage_prefix of this ObjectStorageLink.
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.

        Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`


        :param object_storage_prefix: The object_storage_prefix of this ObjectStorageLink.
        :type: str
        """
        self._object_storage_prefix = object_storage_prefix

    @property
    def current_job_id(self):
        """
        Gets the current_job_id of this ObjectStorageLink.
        The `OCID`__ of currently running sync job. If no sync job is running, then this will be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The current_job_id of this ObjectStorageLink.
        :rtype: str
        """
        return self._current_job_id

    @current_job_id.setter
    def current_job_id(self, current_job_id):
        """
        Sets the current_job_id of this ObjectStorageLink.
        The `OCID`__ of currently running sync job. If no sync job is running, then this will be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param current_job_id: The current_job_id of this ObjectStorageLink.
        :type: str
        """
        self._current_job_id = current_job_id

    @property
    def last_job_id(self):
        """
        Gets the last_job_id of this ObjectStorageLink.
        The `OCID`__ of last succeeded sync job. If no sync job has previously run, then this will be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The last_job_id of this ObjectStorageLink.
        :rtype: str
        """
        return self._last_job_id

    @last_job_id.setter
    def last_job_id(self, last_job_id):
        """
        Sets the last_job_id of this ObjectStorageLink.
        The `OCID`__ of last succeeded sync job. If no sync job has previously run, then this will be empty.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param last_job_id: The last_job_id of this ObjectStorageLink.
        :type: str
        """
        self._last_job_id = last_job_id

    @property
    def is_overwrite(self):
        """
        **[Required]** Gets the is_overwrite of this ObjectStorageLink.
        The flag is an identifier to tell whether the job run has overwrite enabled.
        If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists.
        If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.


        :return: The is_overwrite of this ObjectStorageLink.
        :rtype: bool
        """
        return self._is_overwrite

    @is_overwrite.setter
    def is_overwrite(self, is_overwrite):
        """
        Sets the is_overwrite of this ObjectStorageLink.
        The flag is an identifier to tell whether the job run has overwrite enabled.
        If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists.
        If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.


        :param is_overwrite: The is_overwrite of this ObjectStorageLink.
        :type: bool
        """
        self._is_overwrite = is_overwrite

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
