# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NamedCredentialProperty(object):
    """
    Property item in name/value pair
    """

    #: A constant which can be used with the value_category property of a NamedCredentialProperty.
    #: This constant has a value of "CLEAR_TEXT"
    VALUE_CATEGORY_CLEAR_TEXT = "CLEAR_TEXT"

    #: A constant which can be used with the value_category property of a NamedCredentialProperty.
    #: This constant has a value of "SECRET_IDENTIFIER"
    VALUE_CATEGORY_SECRET_IDENTIFIER = "SECRET_IDENTIFIER"

    #: A constant which can be used with the value_category property of a NamedCredentialProperty.
    #: This constant has a value of "ADB_IDENTIFIER"
    VALUE_CATEGORY_ADB_IDENTIFIER = "ADB_IDENTIFIER"

    #: A constant which can be used with the value_category property of a NamedCredentialProperty.
    #: This constant has a value of "ALLOWED_VALUE"
    VALUE_CATEGORY_ALLOWED_VALUE = "ALLOWED_VALUE"

    def __init__(self, **kwargs):
        """
        Initializes a new NamedCredentialProperty object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this NamedCredentialProperty.
        :type name: str

        :param value:
            The value to assign to the value property of this NamedCredentialProperty.
        :type value: str

        :param value_category:
            The value to assign to the value_category property of this NamedCredentialProperty.
            Allowed values for this property are: "CLEAR_TEXT", "SECRET_IDENTIFIER", "ADB_IDENTIFIER", "ALLOWED_VALUE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type value_category: str

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'value_category': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'value_category': 'valueCategory'
        }
        self._name = None
        self._value = None
        self._value_category = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this NamedCredentialProperty.
        Name of the property


        :return: The name of this NamedCredentialProperty.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this NamedCredentialProperty.
        Name of the property


        :param name: The name of this NamedCredentialProperty.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        **[Required]** Gets the value of this NamedCredentialProperty.
        Value of the property


        :return: The value of this NamedCredentialProperty.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this NamedCredentialProperty.
        Value of the property


        :param value: The value of this NamedCredentialProperty.
        :type: str
        """
        self._value = value

    @property
    def value_category(self):
        """
        **[Required]** Gets the value_category of this NamedCredentialProperty.
        The category of the Named credential property value.
        CLEAR_TEXT indicates the value field contains a clear text value.
        SECRET_IDENTIFIER indicates the value field contains a vault secret ocid identifier.
        ADB_IDENTIFIER indicates the value field contains an Autonomous database ocid identifier.
        ALLOWED_VALUE indicates the value should be selected from the options in the allowedValues field.

        Allowed values for this property are: "CLEAR_TEXT", "SECRET_IDENTIFIER", "ADB_IDENTIFIER", "ALLOWED_VALUE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The value_category of this NamedCredentialProperty.
        :rtype: str
        """
        return self._value_category

    @value_category.setter
    def value_category(self, value_category):
        """
        Sets the value_category of this NamedCredentialProperty.
        The category of the Named credential property value.
        CLEAR_TEXT indicates the value field contains a clear text value.
        SECRET_IDENTIFIER indicates the value field contains a vault secret ocid identifier.
        ADB_IDENTIFIER indicates the value field contains an Autonomous database ocid identifier.
        ALLOWED_VALUE indicates the value should be selected from the options in the allowedValues field.


        :param value_category: The value_category of this NamedCredentialProperty.
        :type: str
        """
        allowed_values = ["CLEAR_TEXT", "SECRET_IDENTIFIER", "ADB_IDENTIFIER", "ALLOWED_VALUE"]
        if not value_allowed_none_or_none_sentinel(value_category, allowed_values):
            value_category = 'UNKNOWN_ENUM_VALUE'
        self._value_category = value_category

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
