# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AvailableServiceSummary(object):
    """
    Available service provider listing for lead generation listings
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AvailableServiceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param icon:
            The value to assign to the icon property of this AvailableServiceSummary.
        :type icon: oci.marketplace_publisher.models.ListingRevisionIconAttachment

        :param listing_id:
            The value to assign to the listing_id property of this AvailableServiceSummary.
        :type listing_id: str

        :param display_name:
            The value to assign to the display_name property of this AvailableServiceSummary.
        :type display_name: str

        :param short_description:
            The value to assign to the short_description property of this AvailableServiceSummary.
        :type short_description: str

        :param tagline:
            The value to assign to the tagline property of this AvailableServiceSummary.
        :type tagline: str

        """
        self.swagger_types = {
            'icon': 'ListingRevisionIconAttachment',
            'listing_id': 'str',
            'display_name': 'str',
            'short_description': 'str',
            'tagline': 'str'
        }
        self.attribute_map = {
            'icon': 'icon',
            'listing_id': 'listingId',
            'display_name': 'displayName',
            'short_description': 'shortDescription',
            'tagline': 'tagline'
        }
        self._icon = None
        self._listing_id = None
        self._display_name = None
        self._short_description = None
        self._tagline = None

    @property
    def icon(self):
        """
        Gets the icon of this AvailableServiceSummary.

        :return: The icon of this AvailableServiceSummary.
        :rtype: oci.marketplace_publisher.models.ListingRevisionIconAttachment
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """
        Sets the icon of this AvailableServiceSummary.

        :param icon: The icon of this AvailableServiceSummary.
        :type: oci.marketplace_publisher.models.ListingRevisionIconAttachment
        """
        self._icon = icon

    @property
    def listing_id(self):
        """
        **[Required]** Gets the listing_id of this AvailableServiceSummary.
        Listing Id for the listing


        :return: The listing_id of this AvailableServiceSummary.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this AvailableServiceSummary.
        Listing Id for the listing


        :param listing_id: The listing_id of this AvailableServiceSummary.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def display_name(self):
        """
        Gets the display_name of this AvailableServiceSummary.
        The name of the listing revision.


        :return: The display_name of this AvailableServiceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AvailableServiceSummary.
        The name of the listing revision.


        :param display_name: The display_name of this AvailableServiceSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def short_description(self):
        """
        Gets the short_description of this AvailableServiceSummary.
        A short description of the listing revision.


        :return: The short_description of this AvailableServiceSummary.
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """
        Sets the short_description of this AvailableServiceSummary.
        A short description of the listing revision.


        :param short_description: The short_description of this AvailableServiceSummary.
        :type: str
        """
        self._short_description = short_description

    @property
    def tagline(self):
        """
        Gets the tagline of this AvailableServiceSummary.
        The tagline of the listing revision.


        :return: The tagline of this AvailableServiceSummary.
        :rtype: str
        """
        return self._tagline

    @tagline.setter
    def tagline(self, tagline):
        """
        Sets the tagline of this AvailableServiceSummary.
        The tagline of the listing revision.


        :param tagline: The tagline of this AvailableServiceSummary.
        :type: str
        """
        self._tagline = tagline

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
