# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListingMeter(object):
    """
    A listing meter information attached by marketplace admin.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ListingMeter object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ListingMeter.
        :type name: str

        :param rate_allocation:
            The value to assign to the rate_allocation property of this ListingMeter.
        :type rate_allocation: float

        :param extended_metadata:
            The value to assign to the extended_metadata property of this ListingMeter.
        :type extended_metadata: dict(str, str)

        """
        self.swagger_types = {
            'name': 'str',
            'rate_allocation': 'float',
            'extended_metadata': 'dict(str, str)'
        }
        self.attribute_map = {
            'name': 'name',
            'rate_allocation': 'rateAllocation',
            'extended_metadata': 'extendedMetadata'
        }
        self._name = None
        self._rate_allocation = None
        self._extended_metadata = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ListingMeter.
        The meter name, ex - MP_BOBO_AP.


        :return: The name of this ListingMeter.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ListingMeter.
        The meter name, ex - MP_BOBO_AP.


        :param name: The name of this ListingMeter.
        :type: str
        """
        self._name = name

    @property
    def rate_allocation(self):
        """
        **[Required]** Gets the rate_allocation of this ListingMeter.
        rate allocation, these are calculated based on rate information at parent part/sku and listing revision.


        :return: The rate_allocation of this ListingMeter.
        :rtype: float
        """
        return self._rate_allocation

    @rate_allocation.setter
    def rate_allocation(self, rate_allocation):
        """
        Sets the rate_allocation of this ListingMeter.
        rate allocation, these are calculated based on rate information at parent part/sku and listing revision.


        :param rate_allocation: The rate_allocation of this ListingMeter.
        :type: float
        """
        self._rate_allocation = rate_allocation

    @property
    def extended_metadata(self):
        """
        **[Required]** Gets the extended_metadata of this ListingMeter.
        Additional metadata key/value pairs for the listing meter.

        For example:

        `{\"pausedOnInstanceStop\": \"True\",\"coreSuffixMeter\": \"_VMWARE\", \"minimumBillingPeriodInHours\": \"755\", \"weight\": \"1.0\" }`


        :return: The extended_metadata of this ListingMeter.
        :rtype: dict(str, str)
        """
        return self._extended_metadata

    @extended_metadata.setter
    def extended_metadata(self, extended_metadata):
        """
        Sets the extended_metadata of this ListingMeter.
        Additional metadata key/value pairs for the listing meter.

        For example:

        `{\"pausedOnInstanceStop\": \"True\",\"coreSuffixMeter\": \"_VMWARE\", \"minimumBillingPeriodInHours\": \"755\", \"weight\": \"1.0\" }`


        :param extended_metadata: The extended_metadata of this ListingMeter.
        :type: dict(str, str)
        """
        self._extended_metadata = extended_metadata

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
