# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NatConfigurationRequest(object):
    """
    Nat Configuration request to use Nat feature on firewall.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NatConfigurationRequest object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param must_enable_private_nat:
            The value to assign to the must_enable_private_nat property of this NatConfigurationRequest.
        :type must_enable_private_nat: bool

        """
        self.swagger_types = {
            'must_enable_private_nat': 'bool'
        }
        self.attribute_map = {
            'must_enable_private_nat': 'mustEnablePrivateNat'
        }
        self._must_enable_private_nat = None

    @property
    def must_enable_private_nat(self):
        """
        **[Required]** Gets the must_enable_private_nat of this NatConfigurationRequest.
        To allocate private NAT IPs to the firewall. The attached network firewall policy must also have NAT rules to enable NAT on any traffic passing through the firewall. The value of this field can not be false to release the NAT IPs given that the attached network firewall policy does not contains any NAT rules. The value of this field should be set to true if the network firewall policy being applied contains NAT rules.


        :return: The must_enable_private_nat of this NatConfigurationRequest.
        :rtype: bool
        """
        return self._must_enable_private_nat

    @must_enable_private_nat.setter
    def must_enable_private_nat(self, must_enable_private_nat):
        """
        Sets the must_enable_private_nat of this NatConfigurationRequest.
        To allocate private NAT IPs to the firewall. The attached network firewall policy must also have NAT rules to enable NAT on any traffic passing through the firewall. The value of this field can not be false to release the NAT IPs given that the attached network firewall policy does not contains any NAT rules. The value of this field should be set to true if the network firewall policy being applied contains NAT rules.


        :param must_enable_private_nat: The must_enable_private_nat of this NatConfigurationRequest.
        :type: bool
        """
        self._must_enable_private_nat = must_enable_private_nat

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
