# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190828

from .update_configuration_details import UpdateConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateMultiTenancyConfigurationDetails(UpdateConfigurationDetails):
    """
    Placeholder service-level configuration for a multi-tenancy environment.
    There are no configurable options for a multi-tenancy service through
    this API, so the derived schema is effectively empty and identical
    to its parent schema.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateMultiTenancyConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.nosql.models.UpdateMultiTenancyConfigurationDetails.environment` attribute
        of this class is ``MULTI_TENANCY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param environment:
            The value to assign to the environment property of this UpdateMultiTenancyConfigurationDetails.
            Allowed values for this property are: "MULTI_TENANCY", "HOSTED"
        :type environment: str

        """
        self.swagger_types = {
            'environment': 'str'
        }
        self.attribute_map = {
            'environment': 'environment'
        }
        self._environment = None
        self._environment = 'MULTI_TENANCY'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
