# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220915


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefaultConfiguration(object):
    """
    Default configurations for PostgreSQL database systems.
    """

    #: A constant which can be used with the lifecycle_state property of a DefaultConfiguration.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DefaultConfiguration.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DefaultConfiguration.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DefaultConfiguration.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DefaultConfiguration.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new DefaultConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DefaultConfiguration.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this DefaultConfiguration.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DefaultConfiguration.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this DefaultConfiguration.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DefaultConfiguration.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this DefaultConfiguration.
        :type lifecycle_details: str

        :param db_version:
            The value to assign to the db_version property of this DefaultConfiguration.
        :type db_version: str

        :param shape:
            The value to assign to the shape property of this DefaultConfiguration.
        :type shape: str

        :param is_flexible:
            The value to assign to the is_flexible property of this DefaultConfiguration.
        :type is_flexible: bool

        :param instance_ocpu_count:
            The value to assign to the instance_ocpu_count property of this DefaultConfiguration.
        :type instance_ocpu_count: int

        :param instance_memory_size_in_gbs:
            The value to assign to the instance_memory_size_in_gbs property of this DefaultConfiguration.
        :type instance_memory_size_in_gbs: int

        :param compatible_shapes:
            The value to assign to the compatible_shapes property of this DefaultConfiguration.
        :type compatible_shapes: list[str]

        :param configuration_details:
            The value to assign to the configuration_details property of this DefaultConfiguration.
        :type configuration_details: oci.psql.models.DefaultConfigurationDetails

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'db_version': 'str',
            'shape': 'str',
            'is_flexible': 'bool',
            'instance_ocpu_count': 'int',
            'instance_memory_size_in_gbs': 'int',
            'compatible_shapes': 'list[str]',
            'configuration_details': 'DefaultConfigurationDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'db_version': 'dbVersion',
            'shape': 'shape',
            'is_flexible': 'isFlexible',
            'instance_ocpu_count': 'instanceOcpuCount',
            'instance_memory_size_in_gbs': 'instanceMemorySizeInGBs',
            'compatible_shapes': 'compatibleShapes',
            'configuration_details': 'configurationDetails'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._time_created = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._db_version = None
        self._shape = None
        self._is_flexible = None
        self._instance_ocpu_count = None
        self._instance_memory_size_in_gbs = None
        self._compatible_shapes = None
        self._configuration_details = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DefaultConfiguration.
        A unique identifier for the configuration.


        :return: The id of this DefaultConfiguration.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DefaultConfiguration.
        A unique identifier for the configuration.


        :param id: The id of this DefaultConfiguration.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DefaultConfiguration.
        A user-friendly display name for the configuration.


        :return: The display_name of this DefaultConfiguration.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DefaultConfiguration.
        A user-friendly display name for the configuration.


        :param display_name: The display_name of this DefaultConfiguration.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DefaultConfiguration.
        A description for the configuration.


        :return: The description of this DefaultConfiguration.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DefaultConfiguration.
        A description for the configuration.


        :param description: The description of this DefaultConfiguration.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DefaultConfiguration.
        The date and time that the configuration was created, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this DefaultConfiguration.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DefaultConfiguration.
        The date and time that the configuration was created, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this DefaultConfiguration.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DefaultConfiguration.
        The current state of the configuration.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DefaultConfiguration.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DefaultConfiguration.
        The current state of the configuration.


        :param lifecycle_state: The lifecycle_state of this DefaultConfiguration.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this DefaultConfiguration.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :return: The lifecycle_details of this DefaultConfiguration.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this DefaultConfiguration.
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.


        :param lifecycle_details: The lifecycle_details of this DefaultConfiguration.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def db_version(self):
        """
        **[Required]** Gets the db_version of this DefaultConfiguration.
        Version of the PostgreSQL database.


        :return: The db_version of this DefaultConfiguration.
        :rtype: str
        """
        return self._db_version

    @db_version.setter
    def db_version(self, db_version):
        """
        Sets the db_version of this DefaultConfiguration.
        Version of the PostgreSQL database.


        :param db_version: The db_version of this DefaultConfiguration.
        :type: str
        """
        self._db_version = db_version

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this DefaultConfiguration.
        The name of the shape for the configuration.

        For multi-shape enabled configurations, it is set to PostgreSQL. Please use compatibleShapes property to get list of supported shapes for such configurations.


        :return: The shape of this DefaultConfiguration.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this DefaultConfiguration.
        The name of the shape for the configuration.

        For multi-shape enabled configurations, it is set to PostgreSQL. Please use compatibleShapes property to get list of supported shapes for such configurations.


        :param shape: The shape of this DefaultConfiguration.
        :type: str
        """
        self._shape = shape

    @property
    def is_flexible(self):
        """
        Gets the is_flexible of this DefaultConfiguration.
        True if the configuration supports flexible shapes, false otherwise.


        :return: The is_flexible of this DefaultConfiguration.
        :rtype: bool
        """
        return self._is_flexible

    @is_flexible.setter
    def is_flexible(self, is_flexible):
        """
        Sets the is_flexible of this DefaultConfiguration.
        True if the configuration supports flexible shapes, false otherwise.


        :param is_flexible: The is_flexible of this DefaultConfiguration.
        :type: bool
        """
        self._is_flexible = is_flexible

    @property
    def instance_ocpu_count(self):
        """
        **[Required]** Gets the instance_ocpu_count of this DefaultConfiguration.
        CPU core count.

        Its value is set to 0 if configuration is for a flexible shape.


        :return: The instance_ocpu_count of this DefaultConfiguration.
        :rtype: int
        """
        return self._instance_ocpu_count

    @instance_ocpu_count.setter
    def instance_ocpu_count(self, instance_ocpu_count):
        """
        Sets the instance_ocpu_count of this DefaultConfiguration.
        CPU core count.

        Its value is set to 0 if configuration is for a flexible shape.


        :param instance_ocpu_count: The instance_ocpu_count of this DefaultConfiguration.
        :type: int
        """
        self._instance_ocpu_count = instance_ocpu_count

    @property
    def instance_memory_size_in_gbs(self):
        """
        **[Required]** Gets the instance_memory_size_in_gbs of this DefaultConfiguration.
        Memory size in gigabytes with 1GB increment.

        Its value is set to 0 if configuration is for a flexible shape.


        :return: The instance_memory_size_in_gbs of this DefaultConfiguration.
        :rtype: int
        """
        return self._instance_memory_size_in_gbs

    @instance_memory_size_in_gbs.setter
    def instance_memory_size_in_gbs(self, instance_memory_size_in_gbs):
        """
        Sets the instance_memory_size_in_gbs of this DefaultConfiguration.
        Memory size in gigabytes with 1GB increment.

        Its value is set to 0 if configuration is for a flexible shape.


        :param instance_memory_size_in_gbs: The instance_memory_size_in_gbs of this DefaultConfiguration.
        :type: int
        """
        self._instance_memory_size_in_gbs = instance_memory_size_in_gbs

    @property
    def compatible_shapes(self):
        """
        **[Required]** Gets the compatible_shapes of this DefaultConfiguration.
        Indicates the collection of compatible shapes for this configuration.


        :return: The compatible_shapes of this DefaultConfiguration.
        :rtype: list[str]
        """
        return self._compatible_shapes

    @compatible_shapes.setter
    def compatible_shapes(self, compatible_shapes):
        """
        Sets the compatible_shapes of this DefaultConfiguration.
        Indicates the collection of compatible shapes for this configuration.


        :param compatible_shapes: The compatible_shapes of this DefaultConfiguration.
        :type: list[str]
        """
        self._compatible_shapes = compatible_shapes

    @property
    def configuration_details(self):
        """
        **[Required]** Gets the configuration_details of this DefaultConfiguration.

        :return: The configuration_details of this DefaultConfiguration.
        :rtype: oci.psql.models.DefaultConfigurationDetails
        """
        return self._configuration_details

    @configuration_details.setter
    def configuration_details(self, configuration_details):
        """
        Sets the configuration_details of this DefaultConfiguration.

        :param configuration_details: The configuration_details of this DefaultConfiguration.
        :type: oci.psql.models.DefaultConfigurationDetails
        """
        self._configuration_details = configuration_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
