# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DefaultConfigurationInfo(object):
    """
    Details of a configuration setting in the OCI Cache Default Config Set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DefaultConfigurationInfo object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_key:
            The value to assign to the config_key property of this DefaultConfigurationInfo.
        :type config_key: str

        :param default_config_value:
            The value to assign to the default_config_value property of this DefaultConfigurationInfo.
        :type default_config_value: str

        :param allowed_values:
            The value to assign to the allowed_values property of this DefaultConfigurationInfo.
        :type allowed_values: str

        :param data_type:
            The value to assign to the data_type property of this DefaultConfigurationInfo.
        :type data_type: str

        :param is_modifiable:
            The value to assign to the is_modifiable property of this DefaultConfigurationInfo.
        :type is_modifiable: bool

        :param description:
            The value to assign to the description property of this DefaultConfigurationInfo.
        :type description: str

        """
        self.swagger_types = {
            'config_key': 'str',
            'default_config_value': 'str',
            'allowed_values': 'str',
            'data_type': 'str',
            'is_modifiable': 'bool',
            'description': 'str'
        }
        self.attribute_map = {
            'config_key': 'configKey',
            'default_config_value': 'defaultConfigValue',
            'allowed_values': 'allowedValues',
            'data_type': 'dataType',
            'is_modifiable': 'isModifiable',
            'description': 'description'
        }
        self._config_key = None
        self._default_config_value = None
        self._allowed_values = None
        self._data_type = None
        self._is_modifiable = None
        self._description = None

    @property
    def config_key(self):
        """
        **[Required]** Gets the config_key of this DefaultConfigurationInfo.
        The key of the configuration setting.


        :return: The config_key of this DefaultConfigurationInfo.
        :rtype: str
        """
        return self._config_key

    @config_key.setter
    def config_key(self, config_key):
        """
        Sets the config_key of this DefaultConfigurationInfo.
        The key of the configuration setting.


        :param config_key: The config_key of this DefaultConfigurationInfo.
        :type: str
        """
        self._config_key = config_key

    @property
    def default_config_value(self):
        """
        **[Required]** Gets the default_config_value of this DefaultConfigurationInfo.
        The default value for the configuration setting.


        :return: The default_config_value of this DefaultConfigurationInfo.
        :rtype: str
        """
        return self._default_config_value

    @default_config_value.setter
    def default_config_value(self, default_config_value):
        """
        Sets the default_config_value of this DefaultConfigurationInfo.
        The default value for the configuration setting.


        :param default_config_value: The default_config_value of this DefaultConfigurationInfo.
        :type: str
        """
        self._default_config_value = default_config_value

    @property
    def allowed_values(self):
        """
        Gets the allowed_values of this DefaultConfigurationInfo.
        Allowed values for the configuration setting.


        :return: The allowed_values of this DefaultConfigurationInfo.
        :rtype: str
        """
        return self._allowed_values

    @allowed_values.setter
    def allowed_values(self, allowed_values):
        """
        Sets the allowed_values of this DefaultConfigurationInfo.
        Allowed values for the configuration setting.


        :param allowed_values: The allowed_values of this DefaultConfigurationInfo.
        :type: str
        """
        self._allowed_values = allowed_values

    @property
    def data_type(self):
        """
        **[Required]** Gets the data_type of this DefaultConfigurationInfo.
        The data type of the configuration setting.


        :return: The data_type of this DefaultConfigurationInfo.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """
        Sets the data_type of this DefaultConfigurationInfo.
        The data type of the configuration setting.


        :param data_type: The data_type of this DefaultConfigurationInfo.
        :type: str
        """
        self._data_type = data_type

    @property
    def is_modifiable(self):
        """
        **[Required]** Gets the is_modifiable of this DefaultConfigurationInfo.
        Indicates if the configuration is modifiable.


        :return: The is_modifiable of this DefaultConfigurationInfo.
        :rtype: bool
        """
        return self._is_modifiable

    @is_modifiable.setter
    def is_modifiable(self, is_modifiable):
        """
        Sets the is_modifiable of this DefaultConfigurationInfo.
        Indicates if the configuration is modifiable.


        :param is_modifiable: The is_modifiable of this DefaultConfigurationInfo.
        :type: bool
        """
        self._is_modifiable = is_modifiable

    @property
    def description(self):
        """
        Gets the description of this DefaultConfigurationInfo.
        Description of the configuration setting.


        :return: The description of this DefaultConfigurationInfo.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DefaultConfigurationInfo.
        Description of the configuration setting.


        :param description: The description of this DefaultConfigurationInfo.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
