# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NodeSummary(object):
    """
    The details of each node in the cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NodeSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param private_endpoint_fqdn:
            The value to assign to the private_endpoint_fqdn property of this NodeSummary.
        :type private_endpoint_fqdn: str

        :param private_endpoint_ip_address:
            The value to assign to the private_endpoint_ip_address property of this NodeSummary.
        :type private_endpoint_ip_address: str

        :param display_name:
            The value to assign to the display_name property of this NodeSummary.
        :type display_name: str

        :param redis_cluster_id:
            The value to assign to the redis_cluster_id property of this NodeSummary.
        :type redis_cluster_id: str

        :param shard_number:
            The value to assign to the shard_number property of this NodeSummary.
        :type shard_number: int

        """
        self.swagger_types = {
            'private_endpoint_fqdn': 'str',
            'private_endpoint_ip_address': 'str',
            'display_name': 'str',
            'redis_cluster_id': 'str',
            'shard_number': 'int'
        }
        self.attribute_map = {
            'private_endpoint_fqdn': 'privateEndpointFqdn',
            'private_endpoint_ip_address': 'privateEndpointIpAddress',
            'display_name': 'displayName',
            'redis_cluster_id': 'redisClusterId',
            'shard_number': 'shardNumber'
        }
        self._private_endpoint_fqdn = None
        self._private_endpoint_ip_address = None
        self._display_name = None
        self._redis_cluster_id = None
        self._shard_number = None

    @property
    def private_endpoint_fqdn(self):
        """
        **[Required]** Gets the private_endpoint_fqdn of this NodeSummary.
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.


        :return: The private_endpoint_fqdn of this NodeSummary.
        :rtype: str
        """
        return self._private_endpoint_fqdn

    @private_endpoint_fqdn.setter
    def private_endpoint_fqdn(self, private_endpoint_fqdn):
        """
        Sets the private_endpoint_fqdn of this NodeSummary.
        The fully qualified domain name (FQDN) of the API endpoint to access a specific node.


        :param private_endpoint_fqdn: The private_endpoint_fqdn of this NodeSummary.
        :type: str
        """
        self._private_endpoint_fqdn = private_endpoint_fqdn

    @property
    def private_endpoint_ip_address(self):
        """
        **[Required]** Gets the private_endpoint_ip_address of this NodeSummary.
        The private IP address of the API endpoint to access a specific node.


        :return: The private_endpoint_ip_address of this NodeSummary.
        :rtype: str
        """
        return self._private_endpoint_ip_address

    @private_endpoint_ip_address.setter
    def private_endpoint_ip_address(self, private_endpoint_ip_address):
        """
        Sets the private_endpoint_ip_address of this NodeSummary.
        The private IP address of the API endpoint to access a specific node.


        :param private_endpoint_ip_address: The private_endpoint_ip_address of this NodeSummary.
        :type: str
        """
        self._private_endpoint_ip_address = private_endpoint_ip_address

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this NodeSummary.
        A user-friendly name of a cluster node.


        :return: The display_name of this NodeSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this NodeSummary.
        A user-friendly name of a cluster node.


        :param display_name: The display_name of this NodeSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def redis_cluster_id(self):
        """
        **[Required]** Gets the redis_cluster_id of this NodeSummary.
        The OCID of the cluster


        :return: The redis_cluster_id of this NodeSummary.
        :rtype: str
        """
        return self._redis_cluster_id

    @redis_cluster_id.setter
    def redis_cluster_id(self, redis_cluster_id):
        """
        Sets the redis_cluster_id of this NodeSummary.
        The OCID of the cluster


        :param redis_cluster_id: The redis_cluster_id of this NodeSummary.
        :type: str
        """
        self._redis_cluster_id = redis_cluster_id

    @property
    def shard_number(self):
        """
        Gets the shard_number of this NodeSummary.
        The shard number to which the node belongs to.


        :return: The shard_number of this NodeSummary.
        :rtype: int
        """
        return self._shard_number

    @shard_number.setter
    def shard_number(self, shard_number):
        """
        Sets the shard_number of this NodeSummary.
        The shard number to which the node belongs to.


        :param shard_number: The shard_number of this NodeSummary.
        :type: int
        """
        self._shard_number = shard_number

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
