# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .allowed_security_configuration import AllowedSecurityConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StatefulZprConfiguration(AllowedSecurityConfiguration):
    """
    Defines the stateful zpr configuration that allowed the traffic.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StatefulZprConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.StatefulZprConfiguration.type` attribute
        of this class is ``STATEFUL_ZPR`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this StatefulZprConfiguration.
            Allowed values for this property are: "NSG", "STATEFUL_NSG", "INGRESS_SECURITY_LIST", "STATEFUL_INGRESS_SECURITY_LIST", "EGRESS_SECURITY_LIST", "STATEFUL_EGRESS_SECURITY_LIST", "ZPR", "STATEFUL_ZPR"
        :type type: str

        :param zpr_policy:
            The value to assign to the zpr_policy property of this StatefulZprConfiguration.
        :type zpr_policy: oci.vn_monitoring.models.ZprPolicy

        """
        self.swagger_types = {
            'type': 'str',
            'zpr_policy': 'ZprPolicy'
        }
        self.attribute_map = {
            'type': 'type',
            'zpr_policy': 'zprPolicy'
        }
        self._type = None
        self._zpr_policy = None
        self._type = 'STATEFUL_ZPR'

    @property
    def zpr_policy(self):
        """
        **[Required]** Gets the zpr_policy of this StatefulZprConfiguration.

        :return: The zpr_policy of this StatefulZprConfiguration.
        :rtype: oci.vn_monitoring.models.ZprPolicy
        """
        return self._zpr_policy

    @zpr_policy.setter
    def zpr_policy(self, zpr_policy):
        """
        Sets the zpr_policy of this StatefulZprConfiguration.

        :param zpr_policy: The zpr_policy of this StatefulZprConfiguration.
        :type: oci.vn_monitoring.models.ZprPolicy
        """
        self._zpr_policy = zpr_policy

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
