# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ManagedInstanceConfiguration(object):
    """
    The configuration for a managed instance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ManagedInstanceConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param discovery_interval:
            The value to assign to the discovery_interval property of this ManagedInstanceConfiguration.
        :type discovery_interval: int

        :param domain_search_paths:
            The value to assign to the domain_search_paths property of this ManagedInstanceConfiguration.
        :type domain_search_paths: list[str]

        """
        self.swagger_types = {
            'discovery_interval': 'int',
            'domain_search_paths': 'list[str]'
        }
        self.attribute_map = {
            'discovery_interval': 'discoveryInterval',
            'domain_search_paths': 'domainSearchPaths'
        }
        self._discovery_interval = None
        self._domain_search_paths = None

    @property
    def discovery_interval(self):
        """
        Gets the discovery_interval of this ManagedInstanceConfiguration.
        Frequency of domain discovery to be run on the managed instance. The unit is in hours.


        :return: The discovery_interval of this ManagedInstanceConfiguration.
        :rtype: int
        """
        return self._discovery_interval

    @discovery_interval.setter
    def discovery_interval(self, discovery_interval):
        """
        Sets the discovery_interval of this ManagedInstanceConfiguration.
        Frequency of domain discovery to be run on the managed instance. The unit is in hours.


        :param discovery_interval: The discovery_interval of this ManagedInstanceConfiguration.
        :type: int
        """
        self._discovery_interval = discovery_interval

    @property
    def domain_search_paths(self):
        """
        Gets the domain_search_paths of this ManagedInstanceConfiguration.
        The whitelisted paths which domain discovery are run against.


        :return: The domain_search_paths of this ManagedInstanceConfiguration.
        :rtype: list[str]
        """
        return self._domain_search_paths

    @domain_search_paths.setter
    def domain_search_paths(self, domain_search_paths):
        """
        Sets the domain_search_paths of this ManagedInstanceConfiguration.
        The whitelisted paths which domain discovery are run against.


        :param domain_search_paths: The domain_search_paths of this ManagedInstanceConfiguration.
        :type: list[str]
        """
        self._domain_search_paths = domain_search_paths

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
