# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SetRestartOrderServerSummary(object):
    """
    This object contains the server with updated restart order in a WebLogic domain.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SetRestartOrderServerSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this SetRestartOrderServerSummary.
        :type name: str

        :param restart_order:
            The value to assign to the restart_order property of this SetRestartOrderServerSummary.
        :type restart_order: int

        """
        self.swagger_types = {
            'name': 'str',
            'restart_order': 'int'
        }
        self.attribute_map = {
            'name': 'name',
            'restart_order': 'restartOrder'
        }
        self._name = None
        self._restart_order = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SetRestartOrderServerSummary.
        The name of the server.


        :return: The name of this SetRestartOrderServerSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SetRestartOrderServerSummary.
        The name of the server.


        :param name: The name of this SetRestartOrderServerSummary.
        :type: str
        """
        self._name = name

    @property
    def restart_order(self):
        """
        **[Required]** Gets the restart_order of this SetRestartOrderServerSummary.
        The restart order number of the server.


        :return: The restart_order of this SetRestartOrderServerSummary.
        :rtype: int
        """
        return self._restart_order

    @restart_order.setter
    def restart_order(self, restart_order):
        """
        Sets the restart_order of this SetRestartOrderServerSummary.
        The restart order number of the server.


        :param restart_order: The restart_order of this SetRestartOrderServerSummary.
        :type: int
        """
        self._restart_order = restart_order

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
