# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityDetails(object):
    """
    A vulnerability details contains details for a vulnerability as reported by the source.
    """

    #: A constant which can be used with the severity property of a VulnerabilityDetails.
    #: This constant has a value of "NONE"
    SEVERITY_NONE = "NONE"

    #: A constant which can be used with the severity property of a VulnerabilityDetails.
    #: This constant has a value of "LOW"
    SEVERITY_LOW = "LOW"

    #: A constant which can be used with the severity property of a VulnerabilityDetails.
    #: This constant has a value of "MEDIUM"
    SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the severity property of a VulnerabilityDetails.
    #: This constant has a value of "HIGH"
    SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the severity property of a VulnerabilityDetails.
    #: This constant has a value of "CRITICAL"
    SEVERITY_CRITICAL = "CRITICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vulnerability_id:
            The value to assign to the vulnerability_id property of this VulnerabilityDetails.
        :type vulnerability_id: str

        :param source:
            The value to assign to the source property of this VulnerabilityDetails.
        :type source: str

        :param is_direct_vulnerability:
            The value to assign to the is_direct_vulnerability property of this VulnerabilityDetails.
        :type is_direct_vulnerability: bool

        :param related_vulnerabilities:
            The value to assign to the related_vulnerabilities property of this VulnerabilityDetails.
        :type related_vulnerabilities: list[oci.adm.models.RelatedVulnerabilityReference]

        :param time_created:
            The value to assign to the time_created property of this VulnerabilityDetails.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this VulnerabilityDetails.
        :type time_updated: datetime

        :param severity:
            The value to assign to the severity property of this VulnerabilityDetails.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type severity: str

        :param metrics:
            The value to assign to the metrics property of this VulnerabilityDetails.
        :type metrics: list[oci.adm.models.VulnerabilityMetric]

        :param status:
            The value to assign to the status property of this VulnerabilityDetails.
        :type status: str

        :param references:
            The value to assign to the references property of this VulnerabilityDetails.
        :type references: list[str]

        :param vulnerability_summary:
            The value to assign to the vulnerability_summary property of this VulnerabilityDetails.
        :type vulnerability_summary: str

        :param vulnerability_description:
            The value to assign to the vulnerability_description property of this VulnerabilityDetails.
        :type vulnerability_description: str

        """
        self.swagger_types = {
            'vulnerability_id': 'str',
            'source': 'str',
            'is_direct_vulnerability': 'bool',
            'related_vulnerabilities': 'list[RelatedVulnerabilityReference]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'severity': 'str',
            'metrics': 'list[VulnerabilityMetric]',
            'status': 'str',
            'references': 'list[str]',
            'vulnerability_summary': 'str',
            'vulnerability_description': 'str'
        }
        self.attribute_map = {
            'vulnerability_id': 'vulnerabilityId',
            'source': 'source',
            'is_direct_vulnerability': 'isDirectVulnerability',
            'related_vulnerabilities': 'relatedVulnerabilities',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'severity': 'severity',
            'metrics': 'metrics',
            'status': 'status',
            'references': 'references',
            'vulnerability_summary': 'vulnerabilitySummary',
            'vulnerability_description': 'vulnerabilityDescription'
        }
        self._vulnerability_id = None
        self._source = None
        self._is_direct_vulnerability = None
        self._related_vulnerabilities = None
        self._time_created = None
        self._time_updated = None
        self._severity = None
        self._metrics = None
        self._status = None
        self._references = None
        self._vulnerability_summary = None
        self._vulnerability_description = None

    @property
    def vulnerability_id(self):
        """
        **[Required]** Gets the vulnerability_id of this VulnerabilityDetails.
        Vulnerability identifier from source, e.g., CVE-1999-0067, GHSA-9vjp-v76f-g363.


        :return: The vulnerability_id of this VulnerabilityDetails.
        :rtype: str
        """
        return self._vulnerability_id

    @vulnerability_id.setter
    def vulnerability_id(self, vulnerability_id):
        """
        Sets the vulnerability_id of this VulnerabilityDetails.
        Vulnerability identifier from source, e.g., CVE-1999-0067, GHSA-9vjp-v76f-g363.


        :param vulnerability_id: The vulnerability_id of this VulnerabilityDetails.
        :type: str
        """
        self._vulnerability_id = vulnerability_id

    @property
    def source(self):
        """
        **[Required]** Gets the source of this VulnerabilityDetails.
        Source that published the vulnerability.


        :return: The source of this VulnerabilityDetails.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this VulnerabilityDetails.
        Source that published the vulnerability.


        :param source: The source of this VulnerabilityDetails.
        :type: str
        """
        self._source = source

    @property
    def is_direct_vulnerability(self):
        """
        Gets the is_direct_vulnerability of this VulnerabilityDetails.
        Indicates if the vulnerability is immediately affecting any artifact in an audit.


        :return: The is_direct_vulnerability of this VulnerabilityDetails.
        :rtype: bool
        """
        return self._is_direct_vulnerability

    @is_direct_vulnerability.setter
    def is_direct_vulnerability(self, is_direct_vulnerability):
        """
        Sets the is_direct_vulnerability of this VulnerabilityDetails.
        Indicates if the vulnerability is immediately affecting any artifact in an audit.


        :param is_direct_vulnerability: The is_direct_vulnerability of this VulnerabilityDetails.
        :type: bool
        """
        self._is_direct_vulnerability = is_direct_vulnerability

    @property
    def related_vulnerabilities(self):
        """
        Gets the related_vulnerabilities of this VulnerabilityDetails.
        List of related vulnerabilities, as reported by the source, along with aliases, where aliases are the same vulnerability reported by different sources.


        :return: The related_vulnerabilities of this VulnerabilityDetails.
        :rtype: list[oci.adm.models.RelatedVulnerabilityReference]
        """
        return self._related_vulnerabilities

    @related_vulnerabilities.setter
    def related_vulnerabilities(self, related_vulnerabilities):
        """
        Sets the related_vulnerabilities of this VulnerabilityDetails.
        List of related vulnerabilities, as reported by the source, along with aliases, where aliases are the same vulnerability reported by different sources.


        :param related_vulnerabilities: The related_vulnerabilities of this VulnerabilityDetails.
        :type: list[oci.adm.models.RelatedVulnerabilityReference]
        """
        self._related_vulnerabilities = related_vulnerabilities

    @property
    def time_created(self):
        """
        Gets the time_created of this VulnerabilityDetails.
        Date when the vulnerability was published, at the source.


        :return: The time_created of this VulnerabilityDetails.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this VulnerabilityDetails.
        Date when the vulnerability was published, at the source.


        :param time_created: The time_created of this VulnerabilityDetails.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this VulnerabilityDetails.
        Date when the vulnerability was last modified, at the source.


        :return: The time_updated of this VulnerabilityDetails.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this VulnerabilityDetails.
        Date when the vulnerability was last modified, at the source.


        :param time_updated: The time_updated of this VulnerabilityDetails.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def severity(self):
        """
        Gets the severity of this VulnerabilityDetails.
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The severity of this VulnerabilityDetails.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this VulnerabilityDetails.
        ADM qualitative severity score. Can be either NONE, LOW, MEDIUM, HIGH or CRITICAL.


        :param severity: The severity of this VulnerabilityDetails.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(severity, allowed_values):
            severity = 'UNKNOWN_ENUM_VALUE'
        self._severity = severity

    @property
    def metrics(self):
        """
        Gets the metrics of this VulnerabilityDetails.
        List of reported metrics by the source.


        :return: The metrics of this VulnerabilityDetails.
        :rtype: list[oci.adm.models.VulnerabilityMetric]
        """
        return self._metrics

    @metrics.setter
    def metrics(self, metrics):
        """
        Sets the metrics of this VulnerabilityDetails.
        List of reported metrics by the source.


        :param metrics: The metrics of this VulnerabilityDetails.
        :type: list[oci.adm.models.VulnerabilityMetric]
        """
        self._metrics = metrics

    @property
    def status(self):
        """
        Gets the status of this VulnerabilityDetails.
        The status of the vulnerability, may be one of Analyzed, Rejected, Modified, Awaiting Analysis, Undergoing Analysis, Published, Withdrawn, Received as reported by the source.


        :return: The status of this VulnerabilityDetails.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this VulnerabilityDetails.
        The status of the vulnerability, may be one of Analyzed, Rejected, Modified, Awaiting Analysis, Undergoing Analysis, Published, Withdrawn, Received as reported by the source.


        :param status: The status of this VulnerabilityDetails.
        :type: str
        """
        self._status = status

    @property
    def references(self):
        """
        Gets the references of this VulnerabilityDetails.
        References of the vulnerability at source.


        :return: The references of this VulnerabilityDetails.
        :rtype: list[str]
        """
        return self._references

    @references.setter
    def references(self, references):
        """
        Sets the references of this VulnerabilityDetails.
        References of the vulnerability at source.


        :param references: The references of this VulnerabilityDetails.
        :type: list[str]
        """
        self._references = references

    @property
    def vulnerability_summary(self):
        """
        Gets the vulnerability_summary of this VulnerabilityDetails.
        Summary of the vulnerability.


        :return: The vulnerability_summary of this VulnerabilityDetails.
        :rtype: str
        """
        return self._vulnerability_summary

    @vulnerability_summary.setter
    def vulnerability_summary(self, vulnerability_summary):
        """
        Sets the vulnerability_summary of this VulnerabilityDetails.
        Summary of the vulnerability.


        :param vulnerability_summary: The vulnerability_summary of this VulnerabilityDetails.
        :type: str
        """
        self._vulnerability_summary = vulnerability_summary

    @property
    def vulnerability_description(self):
        """
        Gets the vulnerability_description of this VulnerabilityDetails.
        Detailed description of the vulnerability.


        :return: The vulnerability_description of this VulnerabilityDetails.
        :rtype: str
        """
        return self._vulnerability_description

    @vulnerability_description.setter
    def vulnerability_description(self, vulnerability_description):
        """
        Sets the vulnerability_description of this VulnerabilityDetails.
        Detailed description of the vulnerability.


        :param vulnerability_description: The vulnerability_description of this VulnerabilityDetails.
        :type: str
        """
        self._vulnerability_description = vulnerability_description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
