# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VulnerabilityMetric(object):
    """
    A quantifiable measure to assess vulnerability potent by various contexts.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VulnerabilityMetric object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this VulnerabilityMetric.
        :type type: str

        :param source:
            The value to assign to the source property of this VulnerabilityMetric.
        :type source: str

        :param score:
            The value to assign to the score property of this VulnerabilityMetric.
        :type score: float

        :param value:
            The value to assign to the value property of this VulnerabilityMetric.
        :type value: str

        """
        self.swagger_types = {
            'type': 'str',
            'source': 'str',
            'score': 'float',
            'value': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'source': 'source',
            'score': 'score',
            'value': 'value'
        }
        self._type = None
        self._source = None
        self._score = None
        self._value = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this VulnerabilityMetric.
        Type of the vulnerability metric e.g., CVSS2, CVSS3, Severity.


        :return: The type of this VulnerabilityMetric.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this VulnerabilityMetric.
        Type of the vulnerability metric e.g., CVSS2, CVSS3, Severity.


        :param type: The type of this VulnerabilityMetric.
        :type: str
        """
        self._type = type

    @property
    def source(self):
        """
        **[Required]** Gets the source of this VulnerabilityMetric.
        Source of the vulnerability metric e.g., NVD, CISA-ADP, OSV.


        :return: The source of this VulnerabilityMetric.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this VulnerabilityMetric.
        Source of the vulnerability metric e.g., NVD, CISA-ADP, OSV.


        :param source: The source of this VulnerabilityMetric.
        :type: str
        """
        self._source = source

    @property
    def score(self):
        """
        Gets the score of this VulnerabilityMetric.
        Numerical representation of metric (if exists). For example for CVSS vectors, the score is the base score according to the CVSS scoring system.


        :return: The score of this VulnerabilityMetric.
        :rtype: float
        """
        return self._score

    @score.setter
    def score(self, score):
        """
        Sets the score of this VulnerabilityMetric.
        Numerical representation of metric (if exists). For example for CVSS vectors, the score is the base score according to the CVSS scoring system.


        :param score: The score of this VulnerabilityMetric.
        :type: float
        """
        self._score = score

    @property
    def value(self):
        """
        **[Required]** Gets the value of this VulnerabilityMetric.
        Value of the vulnerability metric e.g., a string representation of a severity value or a cvss vector.


        :return: The value of this VulnerabilityMetric.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this VulnerabilityMetric.
        Value of the vulnerability metric e.g., a string representation of a severity value or a cvss vector.


        :param value: The value of this VulnerabilityMetric.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
