# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InvoiceKvModelSubTypeDetails(object):
    """
    Invoice KV model sub type details
    """

    #: A constant which can be used with the model_sub_type property of a InvoiceKvModelSubTypeDetails.
    #: This constant has a value of "RECEIPT"
    MODEL_SUB_TYPE_RECEIPT = "RECEIPT"

    #: A constant which can be used with the model_sub_type property of a InvoiceKvModelSubTypeDetails.
    #: This constant has a value of "INVOICE"
    MODEL_SUB_TYPE_INVOICE = "INVOICE"

    #: A constant which can be used with the model_sub_type property of a InvoiceKvModelSubTypeDetails.
    #: This constant has a value of "PASSPORT"
    MODEL_SUB_TYPE_PASSPORT = "PASSPORT"

    #: A constant which can be used with the model_sub_type property of a InvoiceKvModelSubTypeDetails.
    #: This constant has a value of "DRIVER_LICENSE"
    MODEL_SUB_TYPE_DRIVER_LICENSE = "DRIVER_LICENSE"

    #: A constant which can be used with the model_sub_type property of a InvoiceKvModelSubTypeDetails.
    #: This constant has a value of "HEALTH_INSURANCE_ID"
    MODEL_SUB_TYPE_HEALTH_INSURANCE_ID = "HEALTH_INSURANCE_ID"

    def __init__(self, **kwargs):
        """
        Initializes a new InvoiceKvModelSubTypeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_sub_type:
            The value to assign to the model_sub_type property of this InvoiceKvModelSubTypeDetails.
            Allowed values for this property are: "RECEIPT", "INVOICE", "PASSPORT", "DRIVER_LICENSE", "HEALTH_INSURANCE_ID"
        :type model_sub_type: str

        """
        self.swagger_types = {
            'model_sub_type': 'str'
        }
        self.attribute_map = {
            'model_sub_type': 'modelSubType'
        }
        self._model_sub_type = None

    @property
    def model_sub_type(self):
        """
        **[Required]** Gets the model_sub_type of this InvoiceKvModelSubTypeDetails.
        The model sub type for KEY_VALUE_EXTRACTION
        The allowed values are:
        - `RECEIPT`
        - `INVOICE`
        - `PASSPORT`
        - `DRIVER_LICENSE`
        - `HEALTH_INSURANCE_ID`

        Allowed values for this property are: "RECEIPT", "INVOICE", "PASSPORT", "DRIVER_LICENSE", "HEALTH_INSURANCE_ID"


        :return: The model_sub_type of this InvoiceKvModelSubTypeDetails.
        :rtype: str
        """
        return self._model_sub_type

    @model_sub_type.setter
    def model_sub_type(self, model_sub_type):
        """
        Sets the model_sub_type of this InvoiceKvModelSubTypeDetails.
        The model sub type for KEY_VALUE_EXTRACTION
        The allowed values are:
        - `RECEIPT`
        - `INVOICE`
        - `PASSPORT`
        - `DRIVER_LICENSE`
        - `HEALTH_INSURANCE_ID`


        :param model_sub_type: The model_sub_type of this InvoiceKvModelSubTypeDetails.
        :type: str
        """
        allowed_values = ["RECEIPT", "INVOICE", "PASSPORT", "DRIVER_LICENSE", "HEALTH_INSURANCE_ID"]
        if not value_allowed_none_or_none_sentinel(model_sub_type, allowed_values):
            raise ValueError(
                f"Invalid value for `model_sub_type`, must be None or one of {allowed_values}"
            )
        self._model_sub_type = model_sub_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
