# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PatchModelDetails(object):
    """
    The model parameters to be updated using patch operation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PatchModelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operations:
            The value to assign to the operations property of this PatchModelDetails.
        :type operations: list[oci.ai_document.models.PatchModelOperation]

        """
        self.swagger_types = {
            'operations': 'list[PatchModelOperation]'
        }
        self.attribute_map = {
            'operations': 'operations'
        }
        self._operations = None

    @property
    def operations(self):
        """
        Gets the operations of this PatchModelDetails.
        A list of patch operations for model.


        :return: The operations of this PatchModelDetails.
        :rtype: list[oci.ai_document.models.PatchModelOperation]
        """
        return self._operations

    @operations.setter
    def operations(self, operations):
        """
        Sets the operations of this PatchModelDetails.
        A list of patch operations for model.


        :param operations: The operations of this PatchModelDetails.
        :type: list[oci.ai_document.models.PatchModelOperation]
        """
        self._operations = operations

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
