# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCustomizationDetails(object):
    """
    The information about the new Customization.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCustomizationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateCustomizationDetails.
        :type compartment_id: str

        :param alias:
            The value to assign to the alias property of this CreateCustomizationDetails.
        :type alias: str

        :param display_name:
            The value to assign to the display_name property of this CreateCustomizationDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateCustomizationDetails.
        :type description: str

        :param model_details:
            The value to assign to the model_details property of this CreateCustomizationDetails.
        :type model_details: oci.ai_speech.models.CustomizationModelDetails

        :param training_dataset:
            The value to assign to the training_dataset property of this CreateCustomizationDetails.
        :type training_dataset: oci.ai_speech.models.CustomizationDatasetDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCustomizationDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCustomizationDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'alias': 'str',
            'display_name': 'str',
            'description': 'str',
            'model_details': 'CustomizationModelDetails',
            'training_dataset': 'CustomizationDatasetDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'alias': 'alias',
            'display_name': 'displayName',
            'description': 'description',
            'model_details': 'modelDetails',
            'training_dataset': 'trainingDataset',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._alias = None
        self._display_name = None
        self._description = None
        self._model_details = None
        self._training_dataset = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateCustomizationDetails.
        The `OCID`__ of the compartment where you want to create the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateCustomizationDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateCustomizationDetails.
        The `OCID`__ of the compartment where you want to create the job.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateCustomizationDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def alias(self):
        """
        Gets the alias of this CreateCustomizationDetails.
        Customization Details Alias


        :return: The alias of this CreateCustomizationDetails.
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """
        Sets the alias of this CreateCustomizationDetails.
        Customization Details Alias


        :param alias: The alias of this CreateCustomizationDetails.
        :type: str
        """
        self._alias = alias

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateCustomizationDetails.
        A user-friendly display name for the job.


        :return: The display_name of this CreateCustomizationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCustomizationDetails.
        A user-friendly display name for the job.


        :param display_name: The display_name of this CreateCustomizationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateCustomizationDetails.
        A short description of the job.


        :return: The description of this CreateCustomizationDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateCustomizationDetails.
        A short description of the job.


        :param description: The description of this CreateCustomizationDetails.
        :type: str
        """
        self._description = description

    @property
    def model_details(self):
        """
        **[Required]** Gets the model_details of this CreateCustomizationDetails.

        :return: The model_details of this CreateCustomizationDetails.
        :rtype: oci.ai_speech.models.CustomizationModelDetails
        """
        return self._model_details

    @model_details.setter
    def model_details(self, model_details):
        """
        Sets the model_details of this CreateCustomizationDetails.

        :param model_details: The model_details of this CreateCustomizationDetails.
        :type: oci.ai_speech.models.CustomizationModelDetails
        """
        self._model_details = model_details

    @property
    def training_dataset(self):
        """
        **[Required]** Gets the training_dataset of this CreateCustomizationDetails.

        :return: The training_dataset of this CreateCustomizationDetails.
        :rtype: oci.ai_speech.models.CustomizationDatasetDetails
        """
        return self._training_dataset

    @training_dataset.setter
    def training_dataset(self, training_dataset):
        """
        Sets the training_dataset of this CreateCustomizationDetails.

        :param training_dataset: The training_dataset of this CreateCustomizationDetails.
        :type: oci.ai_speech.models.CustomizationDatasetDetails
        """
        self._training_dataset = training_dataset

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCustomizationDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`.


        :return: The freeform_tags of this CreateCustomizationDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCustomizationDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`.


        :param freeform_tags: The freeform_tags of this CreateCustomizationDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCustomizationDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace-1\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}, \"foo-namespace-2\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}}`.


        :return: The defined_tags of this CreateCustomizationDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCustomizationDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace-1\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}, \"foo-namespace-2\": {\"bar-key-1\": \"value-1\", \"bar-key-2\": \"value-2\"}}`.


        :param defined_tags: The defined_tags of this CreateCustomizationDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
