# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomizationReferencedEntities(object):
    """
    Entities referenced by top level customization.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomizationReferencedEntities object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param alias:
            The value to assign to the alias property of this CustomizationReferencedEntities.
        :type alias: str

        :param id:
            The value to assign to the id property of this CustomizationReferencedEntities.
        :type id: str

        :param entity_type:
            The value to assign to the entity_type property of this CustomizationReferencedEntities.
        :type entity_type: str

        """
        self.swagger_types = {
            'alias': 'str',
            'id': 'str',
            'entity_type': 'str'
        }
        self.attribute_map = {
            'alias': 'alias',
            'id': 'id',
            'entity_type': 'entityType'
        }
        self._alias = None
        self._id = None
        self._entity_type = None

    @property
    def alias(self):
        """
        Gets the alias of this CustomizationReferencedEntities.
        Alias of default referenced Customization for given entityType


        :return: The alias of this CustomizationReferencedEntities.
        :rtype: str
        """
        return self._alias

    @alias.setter
    def alias(self, alias):
        """
        Sets the alias of this CustomizationReferencedEntities.
        Alias of default referenced Customization for given entityType


        :param alias: The alias of this CustomizationReferencedEntities.
        :type: str
        """
        self._alias = alias

    @property
    def id(self):
        """
        Gets the id of this CustomizationReferencedEntities.
        Customization Id of default referenced Customization for given entityType


        :return: The id of this CustomizationReferencedEntities.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CustomizationReferencedEntities.
        Customization Id of default referenced Customization for given entityType


        :param id: The id of this CustomizationReferencedEntities.
        :type: str
        """
        self._id = id

    @property
    def entity_type(self):
        """
        Gets the entity_type of this CustomizationReferencedEntities.
        Customization Entity Type


        :return: The entity_type of this CustomizationReferencedEntities.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this CustomizationReferencedEntities.
        Customization Entity Type


        :param entity_type: The entity_type of this CustomizationReferencedEntities.
        :type: str
        """
        self._entity_type = entity_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
