# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220101

from .realtime_message_authentication import RealtimeMessageAuthentication
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RealtimeMessageAuthenticationCredentials(RealtimeMessageAuthentication):
    """
    The payload for credential-based authentication.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RealtimeMessageAuthenticationCredentials object with values from keyword arguments. The default value of the :py:attr:`~oci.ai_speech.models.RealtimeMessageAuthenticationCredentials.authentication_type` attribute
        of this class is ``CREDENTIALS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param authentication_type:
            The value to assign to the authentication_type property of this RealtimeMessageAuthenticationCredentials.
            Allowed values for this property are: "CREDENTIALS", "TOKEN"
        :type authentication_type: str

        :param compartment_id:
            The value to assign to the compartment_id property of this RealtimeMessageAuthenticationCredentials.
        :type compartment_id: str

        :param headers:
            The value to assign to the headers property of this RealtimeMessageAuthenticationCredentials.
        :type headers: dict(str, str)

        """
        self.swagger_types = {
            'authentication_type': 'str',
            'compartment_id': 'str',
            'headers': 'dict(str, str)'
        }
        self.attribute_map = {
            'authentication_type': 'authenticationType',
            'compartment_id': 'compartmentId',
            'headers': 'headers'
        }
        self._authentication_type = None
        self._compartment_id = None
        self._headers = None
        self._authentication_type = 'CREDENTIALS'

    @property
    def headers(self):
        """
        **[Required]** Gets the headers of this RealtimeMessageAuthenticationCredentials.
        The signed request header object.


        :return: The headers of this RealtimeMessageAuthenticationCredentials.
        :rtype: dict(str, str)
        """
        return self._headers

    @headers.setter
    def headers(self, headers):
        """
        Sets the headers of this RealtimeMessageAuthenticationCredentials.
        The signed request header object.


        :param headers: The headers of this RealtimeMessageAuthenticationCredentials.
        :type: dict(str, str)
        """
        self._headers = headers

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
