# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateVideoJobDetails(object):
    """
    Details about the video analysis.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateVideoJobDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param input_location:
            The value to assign to the input_location property of this CreateVideoJobDetails.
        :type input_location: oci.ai_vision.models.InputLocation

        :param features:
            The value to assign to the features property of this CreateVideoJobDetails.
        :type features: list[oci.ai_vision.models.VideoFeature]

        :param output_location:
            The value to assign to the output_location property of this CreateVideoJobDetails.
        :type output_location: oci.ai_vision.models.OutputLocation

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateVideoJobDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateVideoJobDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateVideoJobDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateVideoJobDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'input_location': 'InputLocation',
            'features': 'list[VideoFeature]',
            'output_location': 'OutputLocation',
            'compartment_id': 'str',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'input_location': 'inputLocation',
            'features': 'features',
            'output_location': 'outputLocation',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._input_location = None
        self._features = None
        self._output_location = None
        self._compartment_id = None
        self._display_name = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def input_location(self):
        """
        **[Required]** Gets the input_location of this CreateVideoJobDetails.

        :return: The input_location of this CreateVideoJobDetails.
        :rtype: oci.ai_vision.models.InputLocation
        """
        return self._input_location

    @input_location.setter
    def input_location(self, input_location):
        """
        Sets the input_location of this CreateVideoJobDetails.

        :param input_location: The input_location of this CreateVideoJobDetails.
        :type: oci.ai_vision.models.InputLocation
        """
        self._input_location = input_location

    @property
    def features(self):
        """
        **[Required]** Gets the features of this CreateVideoJobDetails.
        a list of video analysis features.


        :return: The features of this CreateVideoJobDetails.
        :rtype: list[oci.ai_vision.models.VideoFeature]
        """
        return self._features

    @features.setter
    def features(self, features):
        """
        Sets the features of this CreateVideoJobDetails.
        a list of video analysis features.


        :param features: The features of this CreateVideoJobDetails.
        :type: list[oci.ai_vision.models.VideoFeature]
        """
        self._features = features

    @property
    def output_location(self):
        """
        **[Required]** Gets the output_location of this CreateVideoJobDetails.

        :return: The output_location of this CreateVideoJobDetails.
        :rtype: oci.ai_vision.models.OutputLocation
        """
        return self._output_location

    @output_location.setter
    def output_location(self, output_location):
        """
        Sets the output_location of this CreateVideoJobDetails.

        :param output_location: The output_location of this CreateVideoJobDetails.
        :type: oci.ai_vision.models.OutputLocation
        """
        self._output_location = output_location

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreateVideoJobDetails.
        Compartment identifier from the requester.


        :return: The compartment_id of this CreateVideoJobDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateVideoJobDetails.
        Compartment identifier from the requester.


        :param compartment_id: The compartment_id of this CreateVideoJobDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateVideoJobDetails.
        Video job display name.


        :return: The display_name of this CreateVideoJobDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateVideoJobDetails.
        Video job display name.


        :param display_name: The display_name of this CreateVideoJobDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateVideoJobDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateVideoJobDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateVideoJobDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateVideoJobDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateVideoJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateVideoJobDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateVideoJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateVideoJobDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
