# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApiMetadata(object):
    """
    An ApiDetail contains details such as the service it belongs to, the name of the api, the type of api, and the parameters of the api if it contains.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a ApiMetadata.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ApiMetadata.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ApiMetadata.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ApiMetadata.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ApiMetadata.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ApiMetadata.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new ApiMetadata object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ApiMetadata.
        :type id: str

        :param service_name:
            The value to assign to the service_name property of this ApiMetadata.
        :type service_name: str

        :param display_name:
            The value to assign to the display_name property of this ApiMetadata.
        :type display_name: str

        :param path:
            The value to assign to the path property of this ApiMetadata.
        :type path: str

        :param entity_type:
            The value to assign to the entity_type property of this ApiMetadata.
        :type entity_type: str

        :param api_name:
            The value to assign to the api_name property of this ApiMetadata.
        :type api_name: str

        :param fields:
            The value to assign to the fields property of this ApiMetadata.
        :type fields: list[str]

        :param time_created:
            The value to assign to the time_created property of this ApiMetadata.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ApiMetadata.
        :type time_updated: datetime

        :param time_deleted:
            The value to assign to the time_deleted property of this ApiMetadata.
        :type time_deleted: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ApiMetadata.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ApiMetadata.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ApiMetadata.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ApiMetadata.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ApiMetadata.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'service_name': 'str',
            'display_name': 'str',
            'path': 'str',
            'entity_type': 'str',
            'api_name': 'str',
            'fields': 'list[str]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_deleted': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'service_name': 'serviceName',
            'display_name': 'displayName',
            'path': 'path',
            'entity_type': 'entityType',
            'api_name': 'apiName',
            'fields': 'fields',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_deleted': 'timeDeleted',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._service_name = None
        self._display_name = None
        self._path = None
        self._entity_type = None
        self._api_name = None
        self._fields = None
        self._time_created = None
        self._time_updated = None
        self._time_deleted = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ApiMetadata.
        The `OCID`__ of the ApiDetail.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ApiMetadata.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ApiMetadata.
        The `OCID`__ of the ApiDetail.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ApiMetadata.
        :type: str
        """
        self._id = id

    @property
    def service_name(self):
        """
        Gets the service_name of this ApiMetadata.
        The service Name to which the api belongs to.


        :return: The service_name of this ApiMetadata.
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """
        Sets the service_name of this ApiMetadata.
        The service Name to which the api belongs to.


        :param service_name: The service_name of this ApiMetadata.
        :type: str
        """
        self._service_name = service_name

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ApiMetadata.
        The operation Name of the api. The name must be unique.


        :return: The display_name of this ApiMetadata.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ApiMetadata.
        The operation Name of the api. The name must be unique.


        :param display_name: The display_name of this ApiMetadata.
        :type: str
        """
        self._display_name = display_name

    @property
    def path(self):
        """
        Gets the path of this ApiMetadata.
        rest path of the api.


        :return: The path of this ApiMetadata.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Sets the path of this ApiMetadata.
        rest path of the api.


        :param path: The path of this ApiMetadata.
        :type: str
        """
        self._path = path

    @property
    def entity_type(self):
        """
        Gets the entity_type of this ApiMetadata.
        ResourceType to which the apiMetadata belongs to.


        :return: The entity_type of this ApiMetadata.
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """
        Sets the entity_type of this ApiMetadata.
        ResourceType to which the apiMetadata belongs to.


        :param entity_type: The entity_type of this ApiMetadata.
        :type: str
        """
        self._entity_type = entity_type

    @property
    def api_name(self):
        """
        Gets the api_name of this ApiMetadata.
        The name of the api to execute the api request.


        :return: The api_name of this ApiMetadata.
        :rtype: str
        """
        return self._api_name

    @api_name.setter
    def api_name(self, api_name):
        """
        Sets the api_name of this ApiMetadata.
        The name of the api to execute the api request.


        :param api_name: The api_name of this ApiMetadata.
        :type: str
        """
        self._api_name = api_name

    @property
    def fields(self):
        """
        Gets the fields of this ApiMetadata.
        List of the fields that is use while calling post or put for the data.


        :return: The fields of this ApiMetadata.
        :rtype: list[str]
        """
        return self._fields

    @fields.setter
    def fields(self, fields):
        """
        Sets the fields of this ApiMetadata.
        List of the fields that is use while calling post or put for the data.


        :param fields: The fields of this ApiMetadata.
        :type: list[str]
        """
        self._fields = fields

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ApiMetadata.
        The date and time the PrivilegedApiControl was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ApiMetadata.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ApiMetadata.
        The date and time the PrivilegedApiControl was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ApiMetadata.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ApiMetadata.
        The date and time the PrivilegedApiControl was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ApiMetadata.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ApiMetadata.
        The date and time the PrivilegedApiControl was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ApiMetadata.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_deleted(self):
        """
        Gets the time_deleted of this ApiMetadata.
        The date and time the PrivilegedApiControl was marked for delete, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_deleted of this ApiMetadata.
        :rtype: datetime
        """
        return self._time_deleted

    @time_deleted.setter
    def time_deleted(self, time_deleted):
        """
        Sets the time_deleted of this ApiMetadata.
        The date and time the PrivilegedApiControl was marked for delete, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_deleted: The time_deleted of this ApiMetadata.
        :type: datetime
        """
        self._time_deleted = time_deleted

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ApiMetadata.
        The current state of the ApiMetadata.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ApiMetadata.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ApiMetadata.
        The current state of the ApiMetadata.


        :param lifecycle_state: The lifecycle_state of this ApiMetadata.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ApiMetadata.
        A message that describes the current state of the ApiMetadata in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this ApiMetadata.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ApiMetadata.
        A message that describes the current state of the ApiMetadata in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this ApiMetadata.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ApiMetadata.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ApiMetadata.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ApiMetadata.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ApiMetadata.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ApiMetadata.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ApiMetadata.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ApiMetadata.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ApiMetadata.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ApiMetadata.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ApiMetadata.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ApiMetadata.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ApiMetadata.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
