# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PrivilegedApiControlSummary(object):
    """
    Summary information about a PrivilegedApiControl.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PrivilegedApiControlSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PrivilegedApiControlSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this PrivilegedApiControlSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PrivilegedApiControlSummary.
        :type compartment_id: str

        :param resource_type:
            The value to assign to the resource_type property of this PrivilegedApiControlSummary.
        :type resource_type: str

        :param number_of_approvers:
            The value to assign to the number_of_approvers property of this PrivilegedApiControlSummary.
        :type number_of_approvers: int

        :param time_created:
            The value to assign to the time_created property of this PrivilegedApiControlSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this PrivilegedApiControlSummary.
        :type time_updated: datetime

        :param time_deleted:
            The value to assign to the time_deleted property of this PrivilegedApiControlSummary.
        :type time_deleted: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PrivilegedApiControlSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PrivilegedApiControlSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PrivilegedApiControlSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PrivilegedApiControlSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PrivilegedApiControlSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'resource_type': 'str',
            'number_of_approvers': 'int',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_deleted': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'resource_type': 'resourceType',
            'number_of_approvers': 'numberOfApprovers',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_deleted': 'timeDeleted',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._resource_type = None
        self._number_of_approvers = None
        self._time_created = None
        self._time_updated = None
        self._time_deleted = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PrivilegedApiControlSummary.
        The `OCID`__ of the PrivilegedApiControl.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this PrivilegedApiControlSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PrivilegedApiControlSummary.
        The `OCID`__ of the PrivilegedApiControl.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this PrivilegedApiControlSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this PrivilegedApiControlSummary.
        Name of the privilegedApi control.


        :return: The display_name of this PrivilegedApiControlSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this PrivilegedApiControlSummary.
        Name of the privilegedApi control.


        :param display_name: The display_name of this PrivilegedApiControlSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PrivilegedApiControlSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this PrivilegedApiControlSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PrivilegedApiControlSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this PrivilegedApiControlSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resource_type(self):
        """
        Gets the resource_type of this PrivilegedApiControlSummary.
        resourceType for which the PrivilegedApiControl is applicable


        :return: The resource_type of this PrivilegedApiControlSummary.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this PrivilegedApiControlSummary.
        resourceType for which the PrivilegedApiControl is applicable


        :param resource_type: The resource_type of this PrivilegedApiControlSummary.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def number_of_approvers(self):
        """
        Gets the number_of_approvers of this PrivilegedApiControlSummary.
        Number of approvers required to approve an privilegedApi request.


        :return: The number_of_approvers of this PrivilegedApiControlSummary.
        :rtype: int
        """
        return self._number_of_approvers

    @number_of_approvers.setter
    def number_of_approvers(self, number_of_approvers):
        """
        Sets the number_of_approvers of this PrivilegedApiControlSummary.
        Number of approvers required to approve an privilegedApi request.


        :param number_of_approvers: The number_of_approvers of this PrivilegedApiControlSummary.
        :type: int
        """
        self._number_of_approvers = number_of_approvers

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PrivilegedApiControlSummary.
        The date and time the PrivilegedApiControl was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this PrivilegedApiControlSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PrivilegedApiControlSummary.
        The date and time the PrivilegedApiControl was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this PrivilegedApiControlSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PrivilegedApiControlSummary.
        The date and time the PrivilegedApiControl was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this PrivilegedApiControlSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PrivilegedApiControlSummary.
        The date and time the PrivilegedApiControl was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this PrivilegedApiControlSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_deleted(self):
        """
        Gets the time_deleted of this PrivilegedApiControlSummary.
        Time when the privilegedApi control was deleted, expressed in `RFC 3339`__ timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_deleted of this PrivilegedApiControlSummary.
        :rtype: datetime
        """
        return self._time_deleted

    @time_deleted.setter
    def time_deleted(self, time_deleted):
        """
        Sets the time_deleted of this PrivilegedApiControlSummary.
        Time when the privilegedApi control was deleted, expressed in `RFC 3339`__ timestamp format. Example: '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_deleted: The time_deleted of this PrivilegedApiControlSummary.
        :type: datetime
        """
        self._time_deleted = time_deleted

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this PrivilegedApiControlSummary.
        The current state of the PrivilegedApiControl.


        :return: The lifecycle_state of this PrivilegedApiControlSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PrivilegedApiControlSummary.
        The current state of the PrivilegedApiControl.


        :param lifecycle_state: The lifecycle_state of this PrivilegedApiControlSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this PrivilegedApiControlSummary.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this PrivilegedApiControlSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PrivilegedApiControlSummary.
        A message that describes the current state of the PrivilegedApiControl in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this PrivilegedApiControlSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this PrivilegedApiControlSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PrivilegedApiControlSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PrivilegedApiControlSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PrivilegedApiControlSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this PrivilegedApiControlSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PrivilegedApiControlSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PrivilegedApiControlSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PrivilegedApiControlSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PrivilegedApiControlSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this PrivilegedApiControlSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PrivilegedApiControlSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this PrivilegedApiControlSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
