# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdatePrivilegedApiControlDetails(object):
    """
    The data to update a PrivilegedApiControl.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdatePrivilegedApiControlDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdatePrivilegedApiControlDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdatePrivilegedApiControlDetails.
        :type description: str

        :param resource_type:
            The value to assign to the resource_type property of this UpdatePrivilegedApiControlDetails.
        :type resource_type: str

        :param resources:
            The value to assign to the resources property of this UpdatePrivilegedApiControlDetails.
        :type resources: list[str]

        :param notification_topic_id:
            The value to assign to the notification_topic_id property of this UpdatePrivilegedApiControlDetails.
        :type notification_topic_id: str

        :param approver_group_id_list:
            The value to assign to the approver_group_id_list property of this UpdatePrivilegedApiControlDetails.
        :type approver_group_id_list: list[str]

        :param privileged_operation_list:
            The value to assign to the privileged_operation_list property of this UpdatePrivilegedApiControlDetails.
        :type privileged_operation_list: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]

        :param number_of_approvers:
            The value to assign to the number_of_approvers property of this UpdatePrivilegedApiControlDetails.
        :type number_of_approvers: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdatePrivilegedApiControlDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdatePrivilegedApiControlDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'resource_type': 'str',
            'resources': 'list[str]',
            'notification_topic_id': 'str',
            'approver_group_id_list': 'list[str]',
            'privileged_operation_list': 'list[PrivilegedApiDetails]',
            'number_of_approvers': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'resource_type': 'resourceType',
            'resources': 'resources',
            'notification_topic_id': 'notificationTopicId',
            'approver_group_id_list': 'approverGroupIdList',
            'privileged_operation_list': 'privilegedOperationList',
            'number_of_approvers': 'numberOfApprovers',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._resource_type = None
        self._resources = None
        self._notification_topic_id = None
        self._approver_group_id_list = None
        self._privileged_operation_list = None
        self._number_of_approvers = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdatePrivilegedApiControlDetails.
        Name of the privilegedApi control. Needs to be unique.


        :return: The display_name of this UpdatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdatePrivilegedApiControlDetails.
        Name of the privilegedApi control. Needs to be unique.


        :param display_name: The display_name of this UpdatePrivilegedApiControlDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdatePrivilegedApiControlDetails.
        Description of the privilegedApi control.


        :return: The description of this UpdatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdatePrivilegedApiControlDetails.
        Description of the privilegedApi control.


        :param description: The description of this UpdatePrivilegedApiControlDetails.
        :type: str
        """
        self._description = description

    @property
    def resource_type(self):
        """
        Gets the resource_type of this UpdatePrivilegedApiControlDetails.
        resourceType for which the PrivilegedApiControl is applicable


        :return: The resource_type of this UpdatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this UpdatePrivilegedApiControlDetails.
        resourceType for which the PrivilegedApiControl is applicable


        :param resource_type: The resource_type of this UpdatePrivilegedApiControlDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def resources(self):
        """
        Gets the resources of this UpdatePrivilegedApiControlDetails.
        contains Resource details


        :return: The resources of this UpdatePrivilegedApiControlDetails.
        :rtype: list[str]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this UpdatePrivilegedApiControlDetails.
        contains Resource details


        :param resources: The resources of this UpdatePrivilegedApiControlDetails.
        :type: list[str]
        """
        self._resources = resources

    @property
    def notification_topic_id(self):
        """
        Gets the notification_topic_id of this UpdatePrivilegedApiControlDetails.
        The OCID of the OCI Notification topic to publish messages related to this Delegation Control.


        :return: The notification_topic_id of this UpdatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._notification_topic_id

    @notification_topic_id.setter
    def notification_topic_id(self, notification_topic_id):
        """
        Sets the notification_topic_id of this UpdatePrivilegedApiControlDetails.
        The OCID of the OCI Notification topic to publish messages related to this Delegation Control.


        :param notification_topic_id: The notification_topic_id of this UpdatePrivilegedApiControlDetails.
        :type: str
        """
        self._notification_topic_id = notification_topic_id

    @property
    def approver_group_id_list(self):
        """
        Gets the approver_group_id_list of this UpdatePrivilegedApiControlDetails.
        List of user IAM group ids who can approve an privilegedApi request associated with a target resource under the governance of this privilegedApi control.


        :return: The approver_group_id_list of this UpdatePrivilegedApiControlDetails.
        :rtype: list[str]
        """
        return self._approver_group_id_list

    @approver_group_id_list.setter
    def approver_group_id_list(self, approver_group_id_list):
        """
        Sets the approver_group_id_list of this UpdatePrivilegedApiControlDetails.
        List of user IAM group ids who can approve an privilegedApi request associated with a target resource under the governance of this privilegedApi control.


        :param approver_group_id_list: The approver_group_id_list of this UpdatePrivilegedApiControlDetails.
        :type: list[str]
        """
        self._approver_group_id_list = approver_group_id_list

    @property
    def privileged_operation_list(self):
        """
        Gets the privileged_operation_list of this UpdatePrivilegedApiControlDetails.
        List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.


        :return: The privileged_operation_list of this UpdatePrivilegedApiControlDetails.
        :rtype: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]
        """
        return self._privileged_operation_list

    @privileged_operation_list.setter
    def privileged_operation_list(self, privileged_operation_list):
        """
        Sets the privileged_operation_list of this UpdatePrivilegedApiControlDetails.
        List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.


        :param privileged_operation_list: The privileged_operation_list of this UpdatePrivilegedApiControlDetails.
        :type: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]
        """
        self._privileged_operation_list = privileged_operation_list

    @property
    def number_of_approvers(self):
        """
        Gets the number_of_approvers of this UpdatePrivilegedApiControlDetails.
        Number of approvers required to approve an privilegedApi request.


        :return: The number_of_approvers of this UpdatePrivilegedApiControlDetails.
        :rtype: int
        """
        return self._number_of_approvers

    @number_of_approvers.setter
    def number_of_approvers(self, number_of_approvers):
        """
        Sets the number_of_approvers of this UpdatePrivilegedApiControlDetails.
        Number of approvers required to approve an privilegedApi request.


        :param number_of_approvers: The number_of_approvers of this UpdatePrivilegedApiControlDetails.
        :type: int
        """
        self._number_of_approvers = number_of_approvers

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdatePrivilegedApiControlDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdatePrivilegedApiControlDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdatePrivilegedApiControlDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdatePrivilegedApiControlDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdatePrivilegedApiControlDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdatePrivilegedApiControlDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdatePrivilegedApiControlDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdatePrivilegedApiControlDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
