# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130

import oci  # noqa: F401
from oci.util import WAIT_RESOURCE_NOT_FOUND  # noqa: F401


class PrivilegedApiRequestsClientCompositeOperations(object):
    """
    This class provides a wrapper around :py:class:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient` and offers convenience methods
    for operations that would otherwise need to be chained together. For example, instead of performing an action
    on a resource (e.g. launching an instance, creating a load balancer) and then using a waiter to wait for the resource
    to enter a given state, you can call a single method in this class to accomplish the same functionality
    """

    def __init__(self, client, **kwargs):
        """
        Creates a new PrivilegedApiRequestsClientCompositeOperations object

        :param PrivilegedApiRequestsClient client:
            The service client which will be wrapped by this object
        """
        self.client = client

    def approve_privileged_api_request_and_wait_for_state(self, privileged_api_request_id, approve_privileged_api_request_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.approve_privileged_api_request` and waits for the :py:class:`~oci.apiaccesscontrol.models.WorkRequest`
        to enter the given state(s).

        :param str privileged_api_request_id: (required)
            unique PrivilegedApiRequest identifier

        :param oci.apiaccesscontrol.models.ApprovePrivilegedApiRequestDetails approve_privileged_api_request_details: (required)
            Details regarding the approval of an privilegedApi request created by the operator.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.apiaccesscontrol.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.approve_privileged_api_request`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.approve_privileged_api_request(privileged_api_request_id, approve_privileged_api_request_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def close_privileged_api_request_and_wait_for_state(self, privileged_api_request_id, close_privileged_api_request_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.close_privileged_api_request` and waits for the :py:class:`~oci.apiaccesscontrol.models.WorkRequest`
        to enter the given state(s).

        :param str privileged_api_request_id: (required)
            unique PrivilegedApiRequest identifier

        :param oci.apiaccesscontrol.models.ClosePrivilegedApiRequestDetails close_privileged_api_request_details: (required)
            Details regarding the close of an privilegedApi request created by the operator.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.apiaccesscontrol.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.close_privileged_api_request`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.close_privileged_api_request(privileged_api_request_id, close_privileged_api_request_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def create_privileged_api_request_and_wait_for_state(self, create_privileged_api_request_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.create_privileged_api_request` and waits for the :py:class:`~oci.apiaccesscontrol.models.WorkRequest`
        to enter the given state(s).

        :param oci.apiaccesscontrol.models.CreatePrivilegedApiRequestDetails create_privileged_api_request_details: (required)
            Details for the new PrivilegedApiRequest.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.apiaccesscontrol.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.create_privileged_api_request`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.create_privileged_api_request(create_privileged_api_request_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def reject_privileged_api_request_and_wait_for_state(self, privileged_api_request_id, reject_privileged_api_request_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.reject_privileged_api_request` and waits for the :py:class:`~oci.apiaccesscontrol.models.WorkRequest`
        to enter the given state(s).

        :param str privileged_api_request_id: (required)
            unique PrivilegedApiRequest identifier

        :param oci.apiaccesscontrol.models.RejectPrivilegedApiRequestDetails reject_privileged_api_request_details: (required)
            Details regarding the rejection of privilegedApi request created by the operator.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.apiaccesscontrol.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.reject_privileged_api_request`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.reject_privileged_api_request(privileged_api_request_id, reject_privileged_api_request_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)

    def revoke_privileged_api_request_and_wait_for_state(self, privileged_api_request_id, revoke_privileged_api_request_details, wait_for_states=[], operation_kwargs={}, waiter_kwargs={}):
        """
        Calls :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.revoke_privileged_api_request` and waits for the :py:class:`~oci.apiaccesscontrol.models.WorkRequest`
        to enter the given state(s).

        :param str privileged_api_request_id: (required)
            unique PrivilegedApiRequest identifier

        :param oci.apiaccesscontrol.models.RevokePrivilegedApiRequestDetails revoke_privileged_api_request_details: (required)
            Details regarding the revocation of privilegedApi request created by the operator.

        :param list[str] wait_for_states:
            An array of states to wait on. These should be valid values for :py:attr:`~oci.apiaccesscontrol.models.WorkRequest.status`

        :param dict operation_kwargs:
            A dictionary of keyword arguments to pass to :py:func:`~oci.apiaccesscontrol.PrivilegedApiRequestsClient.revoke_privileged_api_request`

        :param dict waiter_kwargs:
            A dictionary of keyword arguments to pass to the :py:func:`oci.wait_until` function. For example, you could pass ``max_interval_seconds`` or ``max_interval_seconds``
            as dictionary keys to modify how long the waiter function will wait between retries and the maximum amount of time it will wait
        """
        operation_result = self.client.revoke_privileged_api_request(privileged_api_request_id, revoke_privileged_api_request_details, **operation_kwargs)
        if not wait_for_states:
            return operation_result
        lowered_wait_for_states = [w.lower() for w in wait_for_states]
        if 'opc-work-request-id' not in operation_result.headers:
            return operation_result
        wait_for_resource_id = operation_result.headers['opc-work-request-id']

        try:
            waiter_result = oci.wait_until(
                self.client,
                self.client.get_work_request(wait_for_resource_id),
                evaluate_response=lambda r: getattr(r.data, 'status') and getattr(r.data, 'status').lower() in lowered_wait_for_states,
                **waiter_kwargs
            )
            result_to_return = waiter_result

            return result_to_return
        except Exception as e:
            raise oci.exceptions.CompositeOperationError(partial_results=[operation_result], cause=e)
