# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201

from .config_summary import ConfigSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentConfigSummary(ConfigSummary):
    """
    Agent configuration for any Agent complying with the OpAMP specification.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentConfigSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.apm_config.models.AgentConfigSummary.config_type` attribute
        of this class is ``AGENT`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AgentConfigSummary.
        :type id: str

        :param config_type:
            The value to assign to the config_type property of this AgentConfigSummary.
            Allowed values for this property are: "SPAN_FILTER", "METRIC_GROUP", "APDEX", "OPTIONS", "AGENT", "MACS_APM_EXTENSION"
        :type config_type: str

        :param time_created:
            The value to assign to the time_created property of this AgentConfigSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this AgentConfigSummary.
        :type time_updated: datetime

        :param created_by:
            The value to assign to the created_by property of this AgentConfigSummary.
        :type created_by: str

        :param updated_by:
            The value to assign to the updated_by property of this AgentConfigSummary.
        :type updated_by: str

        :param etag:
            The value to assign to the etag property of this AgentConfigSummary.
        :type etag: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this AgentConfigSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this AgentConfigSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this AgentConfigSummary.
        :type system_tags: dict(str, dict(str, object))

        :param match_agents_with_attribute_key:
            The value to assign to the match_agents_with_attribute_key property of this AgentConfigSummary.
        :type match_agents_with_attribute_key: list[str]

        :param match_agents_with_attribute_value:
            The value to assign to the match_agents_with_attribute_value property of this AgentConfigSummary.
        :type match_agents_with_attribute_value: str

        :param config:
            The value to assign to the config property of this AgentConfigSummary.
        :type config: oci.apm_config.models.AgentConfigMap

        :param overrides:
            The value to assign to the overrides property of this AgentConfigSummary.
        :type overrides: oci.apm_config.models.AgentConfigOverrides

        """
        self.swagger_types = {
            'id': 'str',
            'config_type': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'created_by': 'str',
            'updated_by': 'str',
            'etag': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'match_agents_with_attribute_key': 'list[str]',
            'match_agents_with_attribute_value': 'str',
            'config': 'AgentConfigMap',
            'overrides': 'AgentConfigOverrides'
        }
        self.attribute_map = {
            'id': 'id',
            'config_type': 'configType',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'created_by': 'createdBy',
            'updated_by': 'updatedBy',
            'etag': 'etag',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'match_agents_with_attribute_key': 'matchAgentsWithAttributeKey',
            'match_agents_with_attribute_value': 'matchAgentsWithAttributeValue',
            'config': 'config',
            'overrides': 'overrides'
        }
        self._id = None
        self._config_type = None
        self._time_created = None
        self._time_updated = None
        self._created_by = None
        self._updated_by = None
        self._etag = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._match_agents_with_attribute_key = None
        self._match_agents_with_attribute_value = None
        self._config = None
        self._overrides = None
        self._config_type = 'AGENT'

    @property
    def match_agents_with_attribute_key(self):
        """
        Gets the match_agents_with_attribute_key of this AgentConfigSummary.
        The agent attribute KEY by which an Agent configuration is matched to an agent.
        All agent configuration objects share the same key. It is [ServiceName, service.name] by default.
        The attribute VALUE corresponding to this KEY is in the matchAgentsWithAttributeValue field.


        :return: The match_agents_with_attribute_key of this AgentConfigSummary.
        :rtype: list[str]
        """
        return self._match_agents_with_attribute_key

    @match_agents_with_attribute_key.setter
    def match_agents_with_attribute_key(self, match_agents_with_attribute_key):
        """
        Sets the match_agents_with_attribute_key of this AgentConfigSummary.
        The agent attribute KEY by which an Agent configuration is matched to an agent.
        All agent configuration objects share the same key. It is [ServiceName, service.name] by default.
        The attribute VALUE corresponding to this KEY is in the matchAgentsWithAttributeValue field.


        :param match_agents_with_attribute_key: The match_agents_with_attribute_key of this AgentConfigSummary.
        :type: list[str]
        """
        self._match_agents_with_attribute_key = match_agents_with_attribute_key

    @property
    def match_agents_with_attribute_value(self):
        """
        Gets the match_agents_with_attribute_value of this AgentConfigSummary.
        The agent attribute VALUE by which an agent configuration is matched to an agent.
        Each agent configuration object must specify a different value.
        The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.


        :return: The match_agents_with_attribute_value of this AgentConfigSummary.
        :rtype: str
        """
        return self._match_agents_with_attribute_value

    @match_agents_with_attribute_value.setter
    def match_agents_with_attribute_value(self, match_agents_with_attribute_value):
        """
        Sets the match_agents_with_attribute_value of this AgentConfigSummary.
        The agent attribute VALUE by which an agent configuration is matched to an agent.
        Each agent configuration object must specify a different value.
        The attribute KEY corresponding to this VALUE is in the matchAgentsWithAttributeKey field.


        :param match_agents_with_attribute_value: The match_agents_with_attribute_value of this AgentConfigSummary.
        :type: str
        """
        self._match_agents_with_attribute_value = match_agents_with_attribute_value

    @property
    def config(self):
        """
        Gets the config of this AgentConfigSummary.

        :return: The config of this AgentConfigSummary.
        :rtype: oci.apm_config.models.AgentConfigMap
        """
        return self._config

    @config.setter
    def config(self, config):
        """
        Sets the config of this AgentConfigSummary.

        :param config: The config of this AgentConfigSummary.
        :type: oci.apm_config.models.AgentConfigMap
        """
        self._config = config

    @property
    def overrides(self):
        """
        Gets the overrides of this AgentConfigSummary.

        :return: The overrides of this AgentConfigSummary.
        :rtype: oci.apm_config.models.AgentConfigOverrides
        """
        return self._overrides

    @overrides.setter
    def overrides(self, overrides):
        """
        Sets the overrides of this AgentConfigSummary.

        :param overrides: The overrides of this AgentConfigSummary.
        :type: oci.apm_config.models.AgentConfigOverrides
        """
        self._overrides = overrides

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
