# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .monitor_configuration import MonitorConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlMonitorConfiguration(MonitorConfiguration):
    """
    Request configuration details for the SQL monitor type.
    """

    #: A constant which can be used with the database_type property of a SqlMonitorConfiguration.
    #: This constant has a value of "ORACLE"
    DATABASE_TYPE_ORACLE = "ORACLE"

    #: A constant which can be used with the database_type property of a SqlMonitorConfiguration.
    #: This constant has a value of "MYSQL"
    DATABASE_TYPE_MYSQL = "MYSQL"

    #: A constant which can be used with the database_connection_type property of a SqlMonitorConfiguration.
    #: This constant has a value of "CLOUD_WALLET"
    DATABASE_CONNECTION_TYPE_CLOUD_WALLET = "CLOUD_WALLET"

    #: A constant which can be used with the database_connection_type property of a SqlMonitorConfiguration.
    #: This constant has a value of "CUSTOM_JDBC"
    DATABASE_CONNECTION_TYPE_CUSTOM_JDBC = "CUSTOM_JDBC"

    def __init__(self, **kwargs):
        """
        Initializes a new SqlMonitorConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.apm_synthetics.models.SqlMonitorConfiguration.config_type` attribute
        of this class is ``SQL_CONFIG`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_type:
            The value to assign to the config_type property of this SqlMonitorConfiguration.
            Allowed values for this property are: "BROWSER_CONFIG", "SCRIPTED_BROWSER_CONFIG", "REST_CONFIG", "SCRIPTED_REST_CONFIG", "NETWORK_CONFIG", "DNS_SERVER_CONFIG", "DNS_TRACE_CONFIG", "DNSSEC_CONFIG", "FTP_CONFIG", "SQL_CONFIG", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type config_type: str

        :param is_failure_retried:
            The value to assign to the is_failure_retried property of this SqlMonitorConfiguration.
        :type is_failure_retried: bool

        :param dns_configuration:
            The value to assign to the dns_configuration property of this SqlMonitorConfiguration.
        :type dns_configuration: oci.apm_synthetics.models.DnsConfiguration

        :param database_type:
            The value to assign to the database_type property of this SqlMonitorConfiguration.
            Allowed values for this property are: "ORACLE", "MYSQL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_type: str

        :param query:
            The value to assign to the query property of this SqlMonitorConfiguration.
        :type query: str

        :param database_authentication_details:
            The value to assign to the database_authentication_details property of this SqlMonitorConfiguration.
        :type database_authentication_details: oci.apm_synthetics.models.BasicAuthenticationDetails

        :param database_role:
            The value to assign to the database_role property of this SqlMonitorConfiguration.
        :type database_role: str

        :param database_connection_type:
            The value to assign to the database_connection_type property of this SqlMonitorConfiguration.
            Allowed values for this property are: "CLOUD_WALLET", "CUSTOM_JDBC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_connection_type: str

        :param connection_string:
            The value to assign to the connection_string property of this SqlMonitorConfiguration.
        :type connection_string: str

        :param database_wallet_details:
            The value to assign to the database_wallet_details property of this SqlMonitorConfiguration.
        :type database_wallet_details: oci.apm_synthetics.models.DatabaseWalletDetails

        """
        self.swagger_types = {
            'config_type': 'str',
            'is_failure_retried': 'bool',
            'dns_configuration': 'DnsConfiguration',
            'database_type': 'str',
            'query': 'str',
            'database_authentication_details': 'BasicAuthenticationDetails',
            'database_role': 'str',
            'database_connection_type': 'str',
            'connection_string': 'str',
            'database_wallet_details': 'DatabaseWalletDetails'
        }
        self.attribute_map = {
            'config_type': 'configType',
            'is_failure_retried': 'isFailureRetried',
            'dns_configuration': 'dnsConfiguration',
            'database_type': 'databaseType',
            'query': 'query',
            'database_authentication_details': 'databaseAuthenticationDetails',
            'database_role': 'databaseRole',
            'database_connection_type': 'databaseConnectionType',
            'connection_string': 'connectionString',
            'database_wallet_details': 'databaseWalletDetails'
        }
        self._config_type = None
        self._is_failure_retried = None
        self._dns_configuration = None
        self._database_type = None
        self._query = None
        self._database_authentication_details = None
        self._database_role = None
        self._database_connection_type = None
        self._connection_string = None
        self._database_wallet_details = None
        self._config_type = 'SQL_CONFIG'

    @property
    def database_type(self):
        """
        Gets the database_type of this SqlMonitorConfiguration.
        Database type.

        Allowed values for this property are: "ORACLE", "MYSQL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_type of this SqlMonitorConfiguration.
        :rtype: str
        """
        return self._database_type

    @database_type.setter
    def database_type(self, database_type):
        """
        Sets the database_type of this SqlMonitorConfiguration.
        Database type.


        :param database_type: The database_type of this SqlMonitorConfiguration.
        :type: str
        """
        allowed_values = ["ORACLE", "MYSQL"]
        if not value_allowed_none_or_none_sentinel(database_type, allowed_values):
            database_type = 'UNKNOWN_ENUM_VALUE'
        self._database_type = database_type

    @property
    def query(self):
        """
        Gets the query of this SqlMonitorConfiguration.
        SQL query to be executed.


        :return: The query of this SqlMonitorConfiguration.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this SqlMonitorConfiguration.
        SQL query to be executed.


        :param query: The query of this SqlMonitorConfiguration.
        :type: str
        """
        self._query = query

    @property
    def database_authentication_details(self):
        """
        Gets the database_authentication_details of this SqlMonitorConfiguration.

        :return: The database_authentication_details of this SqlMonitorConfiguration.
        :rtype: oci.apm_synthetics.models.BasicAuthenticationDetails
        """
        return self._database_authentication_details

    @database_authentication_details.setter
    def database_authentication_details(self, database_authentication_details):
        """
        Sets the database_authentication_details of this SqlMonitorConfiguration.

        :param database_authentication_details: The database_authentication_details of this SqlMonitorConfiguration.
        :type: oci.apm_synthetics.models.BasicAuthenticationDetails
        """
        self._database_authentication_details = database_authentication_details

    @property
    def database_role(self):
        """
        Gets the database_role of this SqlMonitorConfiguration.
        Database role.


        :return: The database_role of this SqlMonitorConfiguration.
        :rtype: str
        """
        return self._database_role

    @database_role.setter
    def database_role(self, database_role):
        """
        Sets the database_role of this SqlMonitorConfiguration.
        Database role.


        :param database_role: The database_role of this SqlMonitorConfiguration.
        :type: str
        """
        self._database_role = database_role

    @property
    def database_connection_type(self):
        """
        Gets the database_connection_type of this SqlMonitorConfiguration.
        Database connection type. Only CUSTOM_JDBC is supported for MYSQL database type.

        Allowed values for this property are: "CLOUD_WALLET", "CUSTOM_JDBC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_connection_type of this SqlMonitorConfiguration.
        :rtype: str
        """
        return self._database_connection_type

    @database_connection_type.setter
    def database_connection_type(self, database_connection_type):
        """
        Sets the database_connection_type of this SqlMonitorConfiguration.
        Database connection type. Only CUSTOM_JDBC is supported for MYSQL database type.


        :param database_connection_type: The database_connection_type of this SqlMonitorConfiguration.
        :type: str
        """
        allowed_values = ["CLOUD_WALLET", "CUSTOM_JDBC"]
        if not value_allowed_none_or_none_sentinel(database_connection_type, allowed_values):
            database_connection_type = 'UNKNOWN_ENUM_VALUE'
        self._database_connection_type = database_connection_type

    @property
    def connection_string(self):
        """
        Gets the connection_string of this SqlMonitorConfiguration.
        Database connection string.


        :return: The connection_string of this SqlMonitorConfiguration.
        :rtype: str
        """
        return self._connection_string

    @connection_string.setter
    def connection_string(self, connection_string):
        """
        Sets the connection_string of this SqlMonitorConfiguration.
        Database connection string.


        :param connection_string: The connection_string of this SqlMonitorConfiguration.
        :type: str
        """
        self._connection_string = connection_string

    @property
    def database_wallet_details(self):
        """
        Gets the database_wallet_details of this SqlMonitorConfiguration.

        :return: The database_wallet_details of this SqlMonitorConfiguration.
        :rtype: oci.apm_synthetics.models.DatabaseWalletDetails
        """
        return self._database_wallet_details

    @database_wallet_details.setter
    def database_wallet_details(self, database_wallet_details):
        """
        Sets the database_wallet_details of this SqlMonitorConfiguration.

        :param database_wallet_details: The database_wallet_details of this SqlMonitorConfiguration.
        :type: oci.apm_synthetics.models.DatabaseWalletDetails
        """
        self._database_wallet_details = database_wallet_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
