# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CustomMetric(object):
    """
    Definition of the Custom Metric.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CustomMetric object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param namespace:
            The value to assign to the namespace property of this CustomMetric.
        :type namespace: str

        :param name:
            The value to assign to the name property of this CustomMetric.
        :type name: str

        :param description:
            The value to assign to the description property of this CustomMetric.
        :type description: str

        :param resource_group:
            The value to assign to the resource_group property of this CustomMetric.
        :type resource_group: str

        :param is_anomaly_detection_enabled:
            The value to assign to the is_anomaly_detection_enabled property of this CustomMetric.
        :type is_anomaly_detection_enabled: bool

        :param compartment:
            The value to assign to the compartment property of this CustomMetric.
        :type compartment: str

        :param unit:
            The value to assign to the unit property of this CustomMetric.
        :type unit: str

        :param is_metric_published:
            The value to assign to the is_metric_published property of this CustomMetric.
        :type is_metric_published: bool

        """
        self.swagger_types = {
            'namespace': 'str',
            'name': 'str',
            'description': 'str',
            'resource_group': 'str',
            'is_anomaly_detection_enabled': 'bool',
            'compartment': 'str',
            'unit': 'str',
            'is_metric_published': 'bool'
        }
        self.attribute_map = {
            'namespace': 'namespace',
            'name': 'name',
            'description': 'description',
            'resource_group': 'resourceGroup',
            'is_anomaly_detection_enabled': 'isAnomalyDetectionEnabled',
            'compartment': 'compartment',
            'unit': 'unit',
            'is_metric_published': 'isMetricPublished'
        }
        self._namespace = None
        self._name = None
        self._description = None
        self._resource_group = None
        self._is_anomaly_detection_enabled = None
        self._compartment = None
        self._unit = None
        self._is_metric_published = None

    @property
    def namespace(self):
        """
        Gets the namespace of this CustomMetric.
        Namespace in the Custom Metric. It defaults to `oracle_apm_custom` if not specified.
        If specified, the necessary OCI policies should be set to allow APM to write to that namespace.


        :return: The namespace of this CustomMetric.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this CustomMetric.
        Namespace in the Custom Metric. It defaults to `oracle_apm_custom` if not specified.
        If specified, the necessary OCI policies should be set to allow APM to write to that namespace.


        :param namespace: The namespace of this CustomMetric.
        :type: str
        """
        self._namespace = namespace

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CustomMetric.
        Name of the Custom Metric.


        :return: The name of this CustomMetric.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CustomMetric.
        Name of the Custom Metric.


        :param name: The name of this CustomMetric.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CustomMetric.
        Description of the Custom Metric.


        :return: The description of this CustomMetric.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CustomMetric.
        Description of the Custom Metric.


        :param description: The description of this CustomMetric.
        :type: str
        """
        self._description = description

    @property
    def resource_group(self):
        """
        Gets the resource_group of this CustomMetric.
        Resource Group of the Custom Metric.


        :return: The resource_group of this CustomMetric.
        :rtype: str
        """
        return self._resource_group

    @resource_group.setter
    def resource_group(self, resource_group):
        """
        Sets the resource_group of this CustomMetric.
        Resource Group of the Custom Metric.


        :param resource_group: The resource_group of this CustomMetric.
        :type: str
        """
        self._resource_group = resource_group

    @property
    def is_anomaly_detection_enabled(self):
        """
        Gets the is_anomaly_detection_enabled of this CustomMetric.
        Indicates whether anomaly Detection should be performed on the generated metric.


        :return: The is_anomaly_detection_enabled of this CustomMetric.
        :rtype: bool
        """
        return self._is_anomaly_detection_enabled

    @is_anomaly_detection_enabled.setter
    def is_anomaly_detection_enabled(self, is_anomaly_detection_enabled):
        """
        Sets the is_anomaly_detection_enabled of this CustomMetric.
        Indicates whether anomaly Detection should be performed on the generated metric.


        :param is_anomaly_detection_enabled: The is_anomaly_detection_enabled of this CustomMetric.
        :type: bool
        """
        self._is_anomaly_detection_enabled = is_anomaly_detection_enabled

    @property
    def compartment(self):
        """
        Gets the compartment of this CustomMetric.
        Compartment of the Monitoring Service. It defaults to the APM domain's compartment if not specified.
        If specified, the necessary OCI policies should be set to allow APM to write to that compartment.


        :return: The compartment of this CustomMetric.
        :rtype: str
        """
        return self._compartment

    @compartment.setter
    def compartment(self, compartment):
        """
        Sets the compartment of this CustomMetric.
        Compartment of the Monitoring Service. It defaults to the APM domain's compartment if not specified.
        If specified, the necessary OCI policies should be set to allow APM to write to that compartment.


        :param compartment: The compartment of this CustomMetric.
        :type: str
        """
        self._compartment = compartment

    @property
    def unit(self):
        """
        Gets the unit of this CustomMetric.
        Unit in which the metric value is reported. For example 'ms'.


        :return: The unit of this CustomMetric.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this CustomMetric.
        Unit in which the metric value is reported. For example 'ms'.


        :param unit: The unit of this CustomMetric.
        :type: str
        """
        self._unit = unit

    @property
    def is_metric_published(self):
        """
        Gets the is_metric_published of this CustomMetric.
        Used in conjunction with the dry run header.  When the dry run header is set and the isPublishMetric flag is set to true, the
        scheduled query is not created, but validations happen to check if the right OCI policies have been set to write to the specified
        namespace/compartment.


        :return: The is_metric_published of this CustomMetric.
        :rtype: bool
        """
        return self._is_metric_published

    @is_metric_published.setter
    def is_metric_published(self, is_metric_published):
        """
        Sets the is_metric_published of this CustomMetric.
        Used in conjunction with the dry run header.  When the dry run header is set and the isPublishMetric flag is set to true, the
        scheduled query is not created, but validations happen to check if the right OCI policies have been set to write to the specified
        namespace/compartment.


        :param is_metric_published: The is_metric_published of this CustomMetric.
        :type: bool
        """
        self._is_metric_published = is_metric_published

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
