# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Vnic(object):
    """
    Private endpoint's VNIC.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Vnic object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Vnic.
        :type id: str

        :param source_ips:
            The value to assign to the source_ips property of this Vnic.
        :type source_ips: list[str]

        """
        self.swagger_types = {
            'id': 'str',
            'source_ips': 'list[str]'
        }
        self.attribute_map = {
            'id': 'id',
            'source_ips': 'sourceIps'
        }
        self._id = None
        self._source_ips = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Vnic.
        The `OCID`__ of the private endpoint's VNIC,
        which resides in the customer's VCN.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this Vnic.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Vnic.
        The `OCID`__ of the private endpoint's VNIC,
        which resides in the customer's VCN.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this Vnic.
        :type: str
        """
        self._id = id

    @property
    def source_ips(self):
        """
        **[Required]** Gets the source_ips of this Vnic.
        A list of private IP addresses (in the customer's VCN) that represent access points for the service.


        :return: The source_ips of this Vnic.
        :rtype: list[str]
        """
        return self._source_ips

    @source_ips.setter
    def source_ips(self, source_ips):
        """
        Sets the source_ips of this Vnic.
        A list of private IP addresses (in the customer's VCN) that represent access points for the service.


        :param source_ips: The source_ips of this Vnic.
        :type: list[str]
        """
        self._source_ips = source_ips

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
