# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CostAnomalyEvent(object):
    """
    A CostAnomalyEvent.
    """

    #: A constant which can be used with the lifecycle_state property of a CostAnomalyEvent.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CostAnomalyEvent.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the cost_monitor_type property of a CostAnomalyEvent.
    #: This constant has a value of "DEFAULT"
    COST_MONITOR_TYPE_DEFAULT = "DEFAULT"

    #: A constant which can be used with the cost_monitor_type property of a CostAnomalyEvent.
    #: This constant has a value of "CUSTOM"
    COST_MONITOR_TYPE_CUSTOM = "CUSTOM"

    #: A constant which can be used with the feedback_response property of a CostAnomalyEvent.
    #: This constant has a value of "ACCURATE_ANOMALY"
    FEEDBACK_RESPONSE_ACCURATE_ANOMALY = "ACCURATE_ANOMALY"

    #: A constant which can be used with the feedback_response property of a CostAnomalyEvent.
    #: This constant has a value of "EXPECTED_ANOMALY"
    FEEDBACK_RESPONSE_EXPECTED_ANOMALY = "EXPECTED_ANOMALY"

    def __init__(self, **kwargs):
        """
        Initializes a new CostAnomalyEvent object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CostAnomalyEvent.
        :type id: str

        :param cost_anomaly_name:
            The value to assign to the cost_anomaly_name property of this CostAnomalyEvent.
        :type cost_anomaly_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CostAnomalyEvent.
        :type compartment_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CostAnomalyEvent.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param cost_monitor_id:
            The value to assign to the cost_monitor_id property of this CostAnomalyEvent.
        :type cost_monitor_id: str

        :param cost_monitor_name:
            The value to assign to the cost_monitor_name property of this CostAnomalyEvent.
        :type cost_monitor_name: str

        :param cost_monitor_type:
            The value to assign to the cost_monitor_type property of this CostAnomalyEvent.
            Allowed values for this property are: "DEFAULT", "CUSTOM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cost_monitor_type: str

        :param target_resource_filter:
            The value to assign to the target_resource_filter property of this CostAnomalyEvent.
        :type target_resource_filter: oci.budget.models.TargetResourceFilter

        :param time_anomaly_event_date:
            The value to assign to the time_anomaly_event_date property of this CostAnomalyEvent.
        :type time_anomaly_event_date: datetime

        :param cost_impact:
            The value to assign to the cost_impact property of this CostAnomalyEvent.
        :type cost_impact: float

        :param cost_variance_percentage:
            The value to assign to the cost_variance_percentage property of this CostAnomalyEvent.
        :type cost_variance_percentage: float

        :param root_cause_detail:
            The value to assign to the root_cause_detail property of this CostAnomalyEvent.
        :type root_cause_detail: oci.budget.models.RootCauseDetail

        :param feedback_response:
            The value to assign to the feedback_response property of this CostAnomalyEvent.
            Allowed values for this property are: "ACCURATE_ANOMALY", "EXPECTED_ANOMALY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type feedback_response: str

        :param time_created:
            The value to assign to the time_created property of this CostAnomalyEvent.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CostAnomalyEvent.
        :type time_updated: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this CostAnomalyEvent.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CostAnomalyEvent.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this CostAnomalyEvent.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'cost_anomaly_name': 'str',
            'compartment_id': 'str',
            'lifecycle_state': 'str',
            'cost_monitor_id': 'str',
            'cost_monitor_name': 'str',
            'cost_monitor_type': 'str',
            'target_resource_filter': 'TargetResourceFilter',
            'time_anomaly_event_date': 'datetime',
            'cost_impact': 'float',
            'cost_variance_percentage': 'float',
            'root_cause_detail': 'RootCauseDetail',
            'feedback_response': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'cost_anomaly_name': 'costAnomalyName',
            'compartment_id': 'compartmentId',
            'lifecycle_state': 'lifecycleState',
            'cost_monitor_id': 'costMonitorId',
            'cost_monitor_name': 'costMonitorName',
            'cost_monitor_type': 'costMonitorType',
            'target_resource_filter': 'targetResourceFilter',
            'time_anomaly_event_date': 'timeAnomalyEventDate',
            'cost_impact': 'costImpact',
            'cost_variance_percentage': 'costVariancePercentage',
            'root_cause_detail': 'rootCauseDetail',
            'feedback_response': 'feedbackResponse',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._cost_anomaly_name = None
        self._compartment_id = None
        self._lifecycle_state = None
        self._cost_monitor_id = None
        self._cost_monitor_name = None
        self._cost_monitor_type = None
        self._target_resource_filter = None
        self._time_anomaly_event_date = None
        self._cost_impact = None
        self._cost_variance_percentage = None
        self._root_cause_detail = None
        self._feedback_response = None
        self._time_created = None
        self._time_updated = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CostAnomalyEvent.
        The OCID of the Cost Anomaly Event.


        :return: The id of this CostAnomalyEvent.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CostAnomalyEvent.
        The OCID of the Cost Anomaly Event.


        :param id: The id of this CostAnomalyEvent.
        :type: str
        """
        self._id = id

    @property
    def cost_anomaly_name(self):
        """
        **[Required]** Gets the cost_anomaly_name of this CostAnomalyEvent.
        The name of the associated cost monitor.


        :return: The cost_anomaly_name of this CostAnomalyEvent.
        :rtype: str
        """
        return self._cost_anomaly_name

    @cost_anomaly_name.setter
    def cost_anomaly_name(self, cost_anomaly_name):
        """
        Sets the cost_anomaly_name of this CostAnomalyEvent.
        The name of the associated cost monitor.


        :param cost_anomaly_name: The cost_anomaly_name of this CostAnomalyEvent.
        :type: str
        """
        self._cost_anomaly_name = cost_anomaly_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CostAnomalyEvent.
        The OCID of the compartment.


        :return: The compartment_id of this CostAnomalyEvent.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CostAnomalyEvent.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this CostAnomalyEvent.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CostAnomalyEvent.
        The current state of the cost anomaly event.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this CostAnomalyEvent.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CostAnomalyEvent.
        The current state of the cost anomaly event.


        :param lifecycle_state: The lifecycle_state of this CostAnomalyEvent.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def cost_monitor_id(self):
        """
        **[Required]** Gets the cost_monitor_id of this CostAnomalyEvent.
        The OCID of the associated cost monitor.


        :return: The cost_monitor_id of this CostAnomalyEvent.
        :rtype: str
        """
        return self._cost_monitor_id

    @cost_monitor_id.setter
    def cost_monitor_id(self, cost_monitor_id):
        """
        Sets the cost_monitor_id of this CostAnomalyEvent.
        The OCID of the associated cost monitor.


        :param cost_monitor_id: The cost_monitor_id of this CostAnomalyEvent.
        :type: str
        """
        self._cost_monitor_id = cost_monitor_id

    @property
    def cost_monitor_name(self):
        """
        **[Required]** Gets the cost_monitor_name of this CostAnomalyEvent.
        The name of the associated cost monitor.


        :return: The cost_monitor_name of this CostAnomalyEvent.
        :rtype: str
        """
        return self._cost_monitor_name

    @cost_monitor_name.setter
    def cost_monitor_name(self, cost_monitor_name):
        """
        Sets the cost_monitor_name of this CostAnomalyEvent.
        The name of the associated cost monitor.


        :param cost_monitor_name: The cost_monitor_name of this CostAnomalyEvent.
        :type: str
        """
        self._cost_monitor_name = cost_monitor_name

    @property
    def cost_monitor_type(self):
        """
        Gets the cost_monitor_type of this CostAnomalyEvent.
        Type of cost monitor

        Allowed values for this property are: "DEFAULT", "CUSTOM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cost_monitor_type of this CostAnomalyEvent.
        :rtype: str
        """
        return self._cost_monitor_type

    @cost_monitor_type.setter
    def cost_monitor_type(self, cost_monitor_type):
        """
        Sets the cost_monitor_type of this CostAnomalyEvent.
        Type of cost monitor


        :param cost_monitor_type: The cost_monitor_type of this CostAnomalyEvent.
        :type: str
        """
        allowed_values = ["DEFAULT", "CUSTOM"]
        if not value_allowed_none_or_none_sentinel(cost_monitor_type, allowed_values):
            cost_monitor_type = 'UNKNOWN_ENUM_VALUE'
        self._cost_monitor_type = cost_monitor_type

    @property
    def target_resource_filter(self):
        """
        **[Required]** Gets the target_resource_filter of this CostAnomalyEvent.

        :return: The target_resource_filter of this CostAnomalyEvent.
        :rtype: oci.budget.models.TargetResourceFilter
        """
        return self._target_resource_filter

    @target_resource_filter.setter
    def target_resource_filter(self, target_resource_filter):
        """
        Sets the target_resource_filter of this CostAnomalyEvent.

        :param target_resource_filter: The target_resource_filter of this CostAnomalyEvent.
        :type: oci.budget.models.TargetResourceFilter
        """
        self._target_resource_filter = target_resource_filter

    @property
    def time_anomaly_event_date(self):
        """
        **[Required]** Gets the time_anomaly_event_date of this CostAnomalyEvent.
        The event date of the anomaly event.


        :return: The time_anomaly_event_date of this CostAnomalyEvent.
        :rtype: datetime
        """
        return self._time_anomaly_event_date

    @time_anomaly_event_date.setter
    def time_anomaly_event_date(self, time_anomaly_event_date):
        """
        Sets the time_anomaly_event_date of this CostAnomalyEvent.
        The event date of the anomaly event.


        :param time_anomaly_event_date: The time_anomaly_event_date of this CostAnomalyEvent.
        :type: datetime
        """
        self._time_anomaly_event_date = time_anomaly_event_date

    @property
    def cost_impact(self):
        """
        Gets the cost_impact of this CostAnomalyEvent.
        The cost impact of the detected anomaly.


        :return: The cost_impact of this CostAnomalyEvent.
        :rtype: float
        """
        return self._cost_impact

    @cost_impact.setter
    def cost_impact(self, cost_impact):
        """
        Sets the cost_impact of this CostAnomalyEvent.
        The cost impact of the detected anomaly.


        :param cost_impact: The cost_impact of this CostAnomalyEvent.
        :type: float
        """
        self._cost_impact = cost_impact

    @property
    def cost_variance_percentage(self):
        """
        Gets the cost_variance_percentage of this CostAnomalyEvent.
        The cost variance percentage of the detected anomaly.


        :return: The cost_variance_percentage of this CostAnomalyEvent.
        :rtype: float
        """
        return self._cost_variance_percentage

    @cost_variance_percentage.setter
    def cost_variance_percentage(self, cost_variance_percentage):
        """
        Sets the cost_variance_percentage of this CostAnomalyEvent.
        The cost variance percentage of the detected anomaly.


        :param cost_variance_percentage: The cost_variance_percentage of this CostAnomalyEvent.
        :type: float
        """
        self._cost_variance_percentage = cost_variance_percentage

    @property
    def root_cause_detail(self):
        """
        Gets the root_cause_detail of this CostAnomalyEvent.

        :return: The root_cause_detail of this CostAnomalyEvent.
        :rtype: oci.budget.models.RootCauseDetail
        """
        return self._root_cause_detail

    @root_cause_detail.setter
    def root_cause_detail(self, root_cause_detail):
        """
        Sets the root_cause_detail of this CostAnomalyEvent.

        :param root_cause_detail: The root_cause_detail of this CostAnomalyEvent.
        :type: oci.budget.models.RootCauseDetail
        """
        self._root_cause_detail = root_cause_detail

    @property
    def feedback_response(self):
        """
        Gets the feedback_response of this CostAnomalyEvent.
        The feedback response for the cost anomaly event.

        Allowed values for this property are: "ACCURATE_ANOMALY", "EXPECTED_ANOMALY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The feedback_response of this CostAnomalyEvent.
        :rtype: str
        """
        return self._feedback_response

    @feedback_response.setter
    def feedback_response(self, feedback_response):
        """
        Sets the feedback_response of this CostAnomalyEvent.
        The feedback response for the cost anomaly event.


        :param feedback_response: The feedback_response of this CostAnomalyEvent.
        :type: str
        """
        allowed_values = ["ACCURATE_ANOMALY", "EXPECTED_ANOMALY"]
        if not value_allowed_none_or_none_sentinel(feedback_response, allowed_values):
            feedback_response = 'UNKNOWN_ENUM_VALUE'
        self._feedback_response = feedback_response

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CostAnomalyEvent.
        The created time of the cost anomaly event.


        :return: The time_created of this CostAnomalyEvent.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CostAnomalyEvent.
        The created time of the cost anomaly event.


        :param time_created: The time_created of this CostAnomalyEvent.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CostAnomalyEvent.
        The updated time of the cost anomaly event.


        :return: The time_updated of this CostAnomalyEvent.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CostAnomalyEvent.
        The updated time of the cost anomaly event.


        :param time_updated: The time_updated of this CostAnomalyEvent.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CostAnomalyEvent.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CostAnomalyEvent.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CostAnomalyEvent.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CostAnomalyEvent.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CostAnomalyEvent.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CostAnomalyEvent.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CostAnomalyEvent.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CostAnomalyEvent.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CostAnomalyEvent.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this CostAnomalyEvent.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CostAnomalyEvent.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this CostAnomalyEvent.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
