# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MetadataDetails(object):
    """
    Used for representing the metadata of the catalog. This denotes the version and format of the CSV file for parsing.
    """

    #: A constant which can be used with the format_version property of a MetadataDetails.
    #: This constant has a value of "V1"
    FORMAT_VERSION_V1 = "V1"

    #: A constant which can be used with the format_version property of a MetadataDetails.
    #: This constant has a value of "V2"
    FORMAT_VERSION_V2 = "V2"

    def __init__(self, **kwargs):
        """
        Initializes a new MetadataDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param format_version:
            The value to assign to the format_version property of this MetadataDetails.
            Allowed values for this property are: "V1", "V2", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type format_version: str

        """
        self.swagger_types = {
            'format_version': 'str'
        }
        self.attribute_map = {
            'format_version': 'formatVersion'
        }
        self._format_version = None

    @property
    def format_version(self):
        """
        **[Required]** Gets the format_version of this MetadataDetails.
        The version for the format of the catalog file being uploaded.

        Allowed values for this property are: "V1", "V2", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The format_version of this MetadataDetails.
        :rtype: str
        """
        return self._format_version

    @format_version.setter
    def format_version(self, format_version):
        """
        Sets the format_version of this MetadataDetails.
        The version for the format of the catalog file being uploaded.


        :param format_version: The format_version of this MetadataDetails.
        :type: str
        """
        allowed_values = ["V1", "V2"]
        if not value_allowed_none_or_none_sentinel(format_version, allowed_values):
            format_version = 'UNKNOWN_ENUM_VALUE'
        self._format_version = format_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
