# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OccmDemandSignalCatalogResourceSummary(object):
    """
    A summary model containing information about the details of a demand signal catalog resource.
    """

    #: A constant which can be used with the namespace property of a OccmDemandSignalCatalogResourceSummary.
    #: This constant has a value of "COMPUTE"
    NAMESPACE_COMPUTE = "COMPUTE"

    #: A constant which can be used with the namespace property of a OccmDemandSignalCatalogResourceSummary.
    #: This constant has a value of "NETWORK"
    NAMESPACE_NETWORK = "NETWORK"

    #: A constant which can be used with the namespace property of a OccmDemandSignalCatalogResourceSummary.
    #: This constant has a value of "GPU"
    NAMESPACE_GPU = "GPU"

    #: A constant which can be used with the namespace property of a OccmDemandSignalCatalogResourceSummary.
    #: This constant has a value of "STORAGE"
    NAMESPACE_STORAGE = "STORAGE"

    def __init__(self, **kwargs):
        """
        Initializes a new OccmDemandSignalCatalogResourceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OccmDemandSignalCatalogResourceSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this OccmDemandSignalCatalogResourceSummary.
        :type compartment_id: str

        :param namespace:
            The value to assign to the namespace property of this OccmDemandSignalCatalogResourceSummary.
            Allowed values for this property are: "COMPUTE", "NETWORK", "GPU", "STORAGE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type namespace: str

        :param name:
            The value to assign to the name property of this OccmDemandSignalCatalogResourceSummary.
        :type name: str

        :param target_compartment_id:
            The value to assign to the target_compartment_id property of this OccmDemandSignalCatalogResourceSummary.
        :type target_compartment_id: str

        :param region:
            The value to assign to the region property of this OccmDemandSignalCatalogResourceSummary.
        :type region: str

        :param availability_domain:
            The value to assign to the availability_domain property of this OccmDemandSignalCatalogResourceSummary.
        :type availability_domain: str

        :param resource_properties:
            The value to assign to the resource_properties property of this OccmDemandSignalCatalogResourceSummary.
        :type resource_properties: oci.capacity_management.models.OccmDemandSignalResourcePropertiesCollection

        :param resource_property_constraints:
            The value to assign to the resource_property_constraints property of this OccmDemandSignalCatalogResourceSummary.
        :type resource_property_constraints: oci.capacity_management.models.OccmDemandSignalResourcePropertyConstraintsCollection

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OccmDemandSignalCatalogResourceSummary.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this OccmDemandSignalCatalogResourceSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this OccmDemandSignalCatalogResourceSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this OccmDemandSignalCatalogResourceSummary.
        :type system_tags: dict(str, dict(str, object))

        :param time_created:
            The value to assign to the time_created property of this OccmDemandSignalCatalogResourceSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this OccmDemandSignalCatalogResourceSummary.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'namespace': 'str',
            'name': 'str',
            'target_compartment_id': 'str',
            'region': 'str',
            'availability_domain': 'str',
            'resource_properties': 'OccmDemandSignalResourcePropertiesCollection',
            'resource_property_constraints': 'OccmDemandSignalResourcePropertyConstraintsCollection',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'namespace': 'namespace',
            'name': 'name',
            'target_compartment_id': 'targetCompartmentId',
            'region': 'region',
            'availability_domain': 'availabilityDomain',
            'resource_properties': 'resourceProperties',
            'resource_property_constraints': 'resourcePropertyConstraints',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._id = None
        self._compartment_id = None
        self._namespace = None
        self._name = None
        self._target_compartment_id = None
        self._region = None
        self._availability_domain = None
        self._resource_properties = None
        self._resource_property_constraints = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OccmDemandSignalCatalogResourceSummary.
        The OCID of the demand signal catalog resource.


        :return: The id of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OccmDemandSignalCatalogResourceSummary.
        The OCID of the demand signal catalog resource.


        :param id: The id of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this OccmDemandSignalCatalogResourceSummary.
        The OCID of the tenancy from which the request to create the demand signal was made.


        :return: The compartment_id of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this OccmDemandSignalCatalogResourceSummary.
        The OCID of the tenancy from which the request to create the demand signal was made.


        :param compartment_id: The compartment_id of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this OccmDemandSignalCatalogResourceSummary.
        The name of the OCI service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.

        Allowed values for this property are: "COMPUTE", "NETWORK", "GPU", "STORAGE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The namespace of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this OccmDemandSignalCatalogResourceSummary.
        The name of the OCI service in consideration for demand signal submission. For example: COMPUTE, NETWORK, GPU etc.


        :param namespace: The namespace of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        allowed_values = ["COMPUTE", "NETWORK", "GPU", "STORAGE"]
        if not value_allowed_none_or_none_sentinel(namespace, allowed_values):
            namespace = 'UNKNOWN_ENUM_VALUE'
        self._namespace = namespace

    @property
    def name(self):
        """
        **[Required]** Gets the name of this OccmDemandSignalCatalogResourceSummary.
        The name of the OCI resource that you want to request.


        :return: The name of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this OccmDemandSignalCatalogResourceSummary.
        The name of the OCI resource that you want to request.


        :param name: The name of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        self._name = name

    @property
    def target_compartment_id(self):
        """
        Gets the target_compartment_id of this OccmDemandSignalCatalogResourceSummary.
        The OCID of the customer tenancy for which this resource will be available for the customer to order against.


        :return: The target_compartment_id of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._target_compartment_id

    @target_compartment_id.setter
    def target_compartment_id(self, target_compartment_id):
        """
        Sets the target_compartment_id of this OccmDemandSignalCatalogResourceSummary.
        The OCID of the customer tenancy for which this resource will be available for the customer to order against.


        :param target_compartment_id: The target_compartment_id of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        self._target_compartment_id = target_compartment_id

    @property
    def region(self):
        """
        Gets the region of this OccmDemandSignalCatalogResourceSummary.
        The name of region for which you want to request the OCI resource. This is an optional parameter.


        :return: The region of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this OccmDemandSignalCatalogResourceSummary.
        The name of region for which you want to request the OCI resource. This is an optional parameter.


        :param region: The region of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        self._region = region

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this OccmDemandSignalCatalogResourceSummary.
        The name of the availability domain for which you want to request the OCI resource. This is an optional parameter.


        :return: The availability_domain of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this OccmDemandSignalCatalogResourceSummary.
        The name of the availability domain for which you want to request the OCI resource. This is an optional parameter.


        :param availability_domain: The availability_domain of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def resource_properties(self):
        """
        Gets the resource_properties of this OccmDemandSignalCatalogResourceSummary.

        :return: The resource_properties of this OccmDemandSignalCatalogResourceSummary.
        :rtype: oci.capacity_management.models.OccmDemandSignalResourcePropertiesCollection
        """
        return self._resource_properties

    @resource_properties.setter
    def resource_properties(self, resource_properties):
        """
        Sets the resource_properties of this OccmDemandSignalCatalogResourceSummary.

        :param resource_properties: The resource_properties of this OccmDemandSignalCatalogResourceSummary.
        :type: oci.capacity_management.models.OccmDemandSignalResourcePropertiesCollection
        """
        self._resource_properties = resource_properties

    @property
    def resource_property_constraints(self):
        """
        Gets the resource_property_constraints of this OccmDemandSignalCatalogResourceSummary.

        :return: The resource_property_constraints of this OccmDemandSignalCatalogResourceSummary.
        :rtype: oci.capacity_management.models.OccmDemandSignalResourcePropertyConstraintsCollection
        """
        return self._resource_property_constraints

    @resource_property_constraints.setter
    def resource_property_constraints(self, resource_property_constraints):
        """
        Sets the resource_property_constraints of this OccmDemandSignalCatalogResourceSummary.

        :param resource_property_constraints: The resource_property_constraints of this OccmDemandSignalCatalogResourceSummary.
        :type: oci.capacity_management.models.OccmDemandSignalResourcePropertyConstraintsCollection
        """
        self._resource_property_constraints = resource_property_constraints

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this OccmDemandSignalCatalogResourceSummary.
        The current lifecycles state of the demand signal catalog resource.


        :return: The lifecycle_state of this OccmDemandSignalCatalogResourceSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OccmDemandSignalCatalogResourceSummary.
        The current lifecycles state of the demand signal catalog resource.


        :param lifecycle_state: The lifecycle_state of this OccmDemandSignalCatalogResourceSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this OccmDemandSignalCatalogResourceSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this OccmDemandSignalCatalogResourceSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this OccmDemandSignalCatalogResourceSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this OccmDemandSignalCatalogResourceSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this OccmDemandSignalCatalogResourceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this OccmDemandSignalCatalogResourceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this OccmDemandSignalCatalogResourceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this OccmDemandSignalCatalogResourceSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this OccmDemandSignalCatalogResourceSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this OccmDemandSignalCatalogResourceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this OccmDemandSignalCatalogResourceSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this OccmDemandSignalCatalogResourceSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this OccmDemandSignalCatalogResourceSummary.
        The time when the demand signal catalog resource was created.


        :return: The time_created of this OccmDemandSignalCatalogResourceSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OccmDemandSignalCatalogResourceSummary.
        The time when the demand signal catalog resource was created.


        :param time_created: The time_created of this OccmDemandSignalCatalogResourceSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this OccmDemandSignalCatalogResourceSummary.
        The time when the demand signal catalog resource was last updated.


        :return: The time_updated of this OccmDemandSignalCatalogResourceSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this OccmDemandSignalCatalogResourceSummary.
        The time when the demand signal catalog resource was last updated.


        :param time_updated: The time_updated of this OccmDemandSignalCatalogResourceSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
