# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210224


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateCertificateAuthorityActionDetails(object):
    """
    The details of the type of certificate authority (CA) update request. Updates can be performed by updating certificate contents or by generating a certificate signing request (CSR).
    """

    #: A constant which can be used with the action_type property of a UpdateCertificateAuthorityActionDetails.
    #: This constant has a value of "UPDATE_CERTIFICATE"
    ACTION_TYPE_UPDATE_CERTIFICATE = "UPDATE_CERTIFICATE"

    #: A constant which can be used with the action_type property of a UpdateCertificateAuthorityActionDetails.
    #: This constant has a value of "GENERATE_CSR"
    ACTION_TYPE_GENERATE_CSR = "GENERATE_CSR"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateCertificateAuthorityActionDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.certificates_management.models.UpdateCertificateAuthorityCertificateDetails`
        * :class:`~oci.certificates_management.models.UpdateCertificateAuthorityGenerateCsrDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_type:
            The value to assign to the action_type property of this UpdateCertificateAuthorityActionDetails.
            Allowed values for this property are: "UPDATE_CERTIFICATE", "GENERATE_CSR"
        :type action_type: str

        """
        self.swagger_types = {
            'action_type': 'str'
        }
        self.attribute_map = {
            'action_type': 'actionType'
        }
        self._action_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['actionType']

        if type == 'UPDATE_CERTIFICATE':
            return 'UpdateCertificateAuthorityCertificateDetails'

        if type == 'GENERATE_CSR':
            return 'UpdateCertificateAuthorityGenerateCsrDetails'
        else:
            return 'UpdateCertificateAuthorityActionDetails'

    @property
    def action_type(self):
        """
        **[Required]** Gets the action_type of this UpdateCertificateAuthorityActionDetails.
        The type of certificate authority (CA) update request. Updates can either involve initiating renewal of the CA by generating a new certificate signing request (CSR) or updating the signed certificate contents of the latest CA version containing a CSR.

        Allowed values for this property are: "UPDATE_CERTIFICATE", "GENERATE_CSR"


        :return: The action_type of this UpdateCertificateAuthorityActionDetails.
        :rtype: str
        """
        return self._action_type

    @action_type.setter
    def action_type(self, action_type):
        """
        Sets the action_type of this UpdateCertificateAuthorityActionDetails.
        The type of certificate authority (CA) update request. Updates can either involve initiating renewal of the CA by generating a new certificate signing request (CSR) or updating the signed certificate contents of the latest CA version containing a CSR.


        :param action_type: The action_type of this UpdateCertificateAuthorityActionDetails.
        :type: str
        """
        allowed_values = ["UPDATE_CERTIFICATE", "GENERATE_CSR"]
        if not value_allowed_none_or_none_sentinel(action_type, allowed_values):
            raise ValueError(
                f"Invalid value for `action_type`, must be None or one of {allowed_values}"
            )
        self._action_type = action_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
