# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180222


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExtendEndpointDecommissionRollbackDeadlineDetails(object):
    """
    The properties that define a request to extend the rollback deadline for a public api endpoint decommission.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExtendEndpointDecommissionRollbackDeadlineDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param rollback_deadline_delay:
            The value to assign to the rollback_deadline_delay property of this ExtendEndpointDecommissionRollbackDeadlineDetails.
        :type rollback_deadline_delay: str

        """
        self.swagger_types = {
            'rollback_deadline_delay': 'str'
        }
        self.attribute_map = {
            'rollback_deadline_delay': 'rollbackDeadlineDelay'
        }
        self._rollback_deadline_delay = None

    @property
    def rollback_deadline_delay(self):
        """
        **[Required]** Gets the rollback_deadline_delay of this ExtendEndpointDecommissionRollbackDeadlineDetails.
        The optional override delay of the rollback deadline once decommission is finished.
        maximum to 30 days could be added. Once Deadline is passed, rollback will not able to be launched.


        :return: The rollback_deadline_delay of this ExtendEndpointDecommissionRollbackDeadlineDetails.
        :rtype: str
        """
        return self._rollback_deadline_delay

    @rollback_deadline_delay.setter
    def rollback_deadline_delay(self, rollback_deadline_delay):
        """
        Sets the rollback_deadline_delay of this ExtendEndpointDecommissionRollbackDeadlineDetails.
        The optional override delay of the rollback deadline once decommission is finished.
        maximum to 30 days could be added. Once Deadline is passed, rollback will not able to be launched.


        :param rollback_deadline_delay: The rollback_deadline_delay of this ExtendEndpointDecommissionRollbackDeadlineDetails.
        :type: str
        """
        self._rollback_deadline_delay = rollback_deadline_delay

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
