# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180222


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PublicApiEndpointDecommissionStatus(object):
    """
    Information regarding a cluster's public api endpoint decommission.
    """

    #: A constant which can be used with the status property of a PublicApiEndpointDecommissionStatus.
    #: This constant has a value of "PENDING"
    STATUS_PENDING = "PENDING"

    #: A constant which can be used with the status property of a PublicApiEndpointDecommissionStatus.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a PublicApiEndpointDecommissionStatus.
    #: This constant has a value of "ROLLING_BACK"
    STATUS_ROLLING_BACK = "ROLLING_BACK"

    #: A constant which can be used with the status property of a PublicApiEndpointDecommissionStatus.
    #: This constant has a value of "DECOMMISSIONED"
    STATUS_DECOMMISSIONED = "DECOMMISSIONED"

    #: A constant which can be used with the status property of a PublicApiEndpointDecommissionStatus.
    #: This constant has a value of "FINALIZED"
    STATUS_FINALIZED = "FINALIZED"

    #: A constant which can be used with the status property of a PublicApiEndpointDecommissionStatus.
    #: This constant has a value of "DECOMMISSION_FAILED"
    STATUS_DECOMMISSION_FAILED = "DECOMMISSION_FAILED"

    #: A constant which can be used with the status property of a PublicApiEndpointDecommissionStatus.
    #: This constant has a value of "ROLLBACK_FAILED"
    STATUS_ROLLBACK_FAILED = "ROLLBACK_FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new PublicApiEndpointDecommissionStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_decommission_rollback_deadline:
            The value to assign to the time_decommission_rollback_deadline property of this PublicApiEndpointDecommissionStatus.
        :type time_decommission_rollback_deadline: datetime

        :param status:
            The value to assign to the status property of this PublicApiEndpointDecommissionStatus.
            Allowed values for this property are: "PENDING", "IN_PROGRESS", "ROLLING_BACK", "DECOMMISSIONED", "FINALIZED", "DECOMMISSION_FAILED", "ROLLBACK_FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        """
        self.swagger_types = {
            'time_decommission_rollback_deadline': 'datetime',
            'status': 'str'
        }
        self.attribute_map = {
            'time_decommission_rollback_deadline': 'timeDecommissionRollbackDeadline',
            'status': 'status'
        }
        self._time_decommission_rollback_deadline = None
        self._status = None

    @property
    def time_decommission_rollback_deadline(self):
        """
        **[Required]** Gets the time_decommission_rollback_deadline of this PublicApiEndpointDecommissionStatus.
        The date and time of rollback deadline for public api endpoint decommission.
        Once the date is passed, rollback is not able to be launched.


        :return: The time_decommission_rollback_deadline of this PublicApiEndpointDecommissionStatus.
        :rtype: datetime
        """
        return self._time_decommission_rollback_deadline

    @time_decommission_rollback_deadline.setter
    def time_decommission_rollback_deadline(self, time_decommission_rollback_deadline):
        """
        Sets the time_decommission_rollback_deadline of this PublicApiEndpointDecommissionStatus.
        The date and time of rollback deadline for public api endpoint decommission.
        Once the date is passed, rollback is not able to be launched.


        :param time_decommission_rollback_deadline: The time_decommission_rollback_deadline of this PublicApiEndpointDecommissionStatus.
        :type: datetime
        """
        self._time_decommission_rollback_deadline = time_decommission_rollback_deadline

    @property
    def status(self):
        """
        **[Required]** Gets the status of this PublicApiEndpointDecommissionStatus.
        The current public api endpoint decommission status of the cluster.

        Allowed values for this property are: "PENDING", "IN_PROGRESS", "ROLLING_BACK", "DECOMMISSIONED", "FINALIZED", "DECOMMISSION_FAILED", "ROLLBACK_FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this PublicApiEndpointDecommissionStatus.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this PublicApiEndpointDecommissionStatus.
        The current public api endpoint decommission status of the cluster.


        :param status: The status of this PublicApiEndpointDecommissionStatus.
        :type: str
        """
        allowed_values = ["PENDING", "IN_PROGRESS", "ROLLING_BACK", "DECOMMISSIONED", "FINALIZED", "DECOMMISSION_FAILED", "ROLLBACK_FAILED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
