# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ByoasnByoipRange(object):
    """
    Information about 'ByoipRange' that has `byoasn` as origin.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ByoasnByoipRange object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cidr_block:
            The value to assign to the cidr_block property of this ByoasnByoipRange.
        :type cidr_block: str

        :param ipv6_cidr_block:
            The value to assign to the ipv6_cidr_block property of this ByoasnByoipRange.
        :type ipv6_cidr_block: str

        :param byoip_range_id:
            The value to assign to the byoip_range_id property of this ByoasnByoipRange.
        :type byoip_range_id: str

        :param as_path_prepend_length:
            The value to assign to the as_path_prepend_length property of this ByoasnByoipRange.
        :type as_path_prepend_length: int

        """
        self.swagger_types = {
            'cidr_block': 'str',
            'ipv6_cidr_block': 'str',
            'byoip_range_id': 'str',
            'as_path_prepend_length': 'int'
        }
        self.attribute_map = {
            'cidr_block': 'cidrBlock',
            'ipv6_cidr_block': 'ipv6CidrBlock',
            'byoip_range_id': 'byoipRangeId',
            'as_path_prepend_length': 'asPathPrependLength'
        }
        self._cidr_block = None
        self._ipv6_cidr_block = None
        self._byoip_range_id = None
        self._as_path_prepend_length = None

    @property
    def cidr_block(self):
        """
        Gets the cidr_block of this ByoasnByoipRange.
        The BYOIP CIDR block range or subrange allocated to an IP pool. This could be all or part of a BYOIP CIDR block.


        :return: The cidr_block of this ByoasnByoipRange.
        :rtype: str
        """
        return self._cidr_block

    @cidr_block.setter
    def cidr_block(self, cidr_block):
        """
        Sets the cidr_block of this ByoasnByoipRange.
        The BYOIP CIDR block range or subrange allocated to an IP pool. This could be all or part of a BYOIP CIDR block.


        :param cidr_block: The cidr_block of this ByoasnByoipRange.
        :type: str
        """
        self._cidr_block = cidr_block

    @property
    def ipv6_cidr_block(self):
        """
        Gets the ipv6_cidr_block of this ByoasnByoipRange.
        The IPv6 prefix being imported to the Oracle cloud. This prefix must be /48 or larger, and can  be subdivided into sub-ranges used
        across multiple VCNs. A BYOIPv6 prefix can be assigned across multiple VCNs, and each VCN must be /64 or larger. You may specify
        a ULA or private IPv6 prefix of /64 or larger to use in the VCN. IPv6-enabled subnets will remain a fixed /64 in size.


        :return: The ipv6_cidr_block of this ByoasnByoipRange.
        :rtype: str
        """
        return self._ipv6_cidr_block

    @ipv6_cidr_block.setter
    def ipv6_cidr_block(self, ipv6_cidr_block):
        """
        Sets the ipv6_cidr_block of this ByoasnByoipRange.
        The IPv6 prefix being imported to the Oracle cloud. This prefix must be /48 or larger, and can  be subdivided into sub-ranges used
        across multiple VCNs. A BYOIPv6 prefix can be assigned across multiple VCNs, and each VCN must be /64 or larger. You may specify
        a ULA or private IPv6 prefix of /64 or larger to use in the VCN. IPv6-enabled subnets will remain a fixed /64 in size.


        :param ipv6_cidr_block: The ipv6_cidr_block of this ByoasnByoipRange.
        :type: str
        """
        self._ipv6_cidr_block = ipv6_cidr_block

    @property
    def byoip_range_id(self):
        """
        **[Required]** Gets the byoip_range_id of this ByoasnByoipRange.
        The `OCID`__ of the `ByoipRange` resource to which the CIDR block belongs.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The byoip_range_id of this ByoasnByoipRange.
        :rtype: str
        """
        return self._byoip_range_id

    @byoip_range_id.setter
    def byoip_range_id(self, byoip_range_id):
        """
        Sets the byoip_range_id of this ByoasnByoipRange.
        The `OCID`__ of the `ByoipRange` resource to which the CIDR block belongs.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param byoip_range_id: The byoip_range_id of this ByoasnByoipRange.
        :type: str
        """
        self._byoip_range_id = byoip_range_id

    @property
    def as_path_prepend_length(self):
        """
        Gets the as_path_prepend_length of this ByoasnByoipRange.
        The as path prepend length.


        :return: The as_path_prepend_length of this ByoasnByoipRange.
        :rtype: int
        """
        return self._as_path_prepend_length

    @as_path_prepend_length.setter
    def as_path_prepend_length(self, as_path_prepend_length):
        """
        Sets the as_path_prepend_length of this ByoasnByoipRange.
        The as path prepend length.


        :param as_path_prepend_length: The as_path_prepend_length of this ByoasnByoipRange.
        :type: int
        """
        self._as_path_prepend_length = as_path_prepend_length

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
