# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeHostConfigurationCheckDetails(object):
    """
    Compute Host Group Configuration Details Check
    """

    #: A constant which can be used with the type property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "FIRMWARE"
    TYPE_FIRMWARE = "FIRMWARE"

    #: A constant which can be used with the type property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "RECYCLE"
    TYPE_RECYCLE = "RECYCLE"

    #: A constant which can be used with the configuration_state property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "CONFORMANT"
    CONFIGURATION_STATE_CONFORMANT = "CONFORMANT"

    #: A constant which can be used with the configuration_state property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "NON_CONFORMANT"
    CONFIGURATION_STATE_NON_CONFORMANT = "NON_CONFORMANT"

    #: A constant which can be used with the configuration_state property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "CHECKING"
    CONFIGURATION_STATE_CHECKING = "CHECKING"

    #: A constant which can be used with the configuration_state property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "PRE_APPLYING"
    CONFIGURATION_STATE_PRE_APPLYING = "PRE_APPLYING"

    #: A constant which can be used with the configuration_state property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "APPLYING"
    CONFIGURATION_STATE_APPLYING = "APPLYING"

    #: A constant which can be used with the configuration_state property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "UNKNOWN"
    CONFIGURATION_STATE_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the recycle_level property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "SKIP_RECYCLE"
    RECYCLE_LEVEL_SKIP_RECYCLE = "SKIP_RECYCLE"

    #: A constant which can be used with the recycle_level property of a ComputeHostConfigurationCheckDetails.
    #: This constant has a value of "FULL_RECYCLE"
    RECYCLE_LEVEL_FULL_RECYCLE = "FULL_RECYCLE"

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeHostConfigurationCheckDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ComputeHostConfigurationCheckDetails.
            Allowed values for this property are: "FIRMWARE", "RECYCLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param configuration_state:
            The value to assign to the configuration_state property of this ComputeHostConfigurationCheckDetails.
            Allowed values for this property are: "CONFORMANT", "NON_CONFORMANT", "CHECKING", "PRE_APPLYING", "APPLYING", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type configuration_state: str

        :param firmware_bundle_id:
            The value to assign to the firmware_bundle_id property of this ComputeHostConfigurationCheckDetails.
        :type firmware_bundle_id: str

        :param recycle_level:
            The value to assign to the recycle_level property of this ComputeHostConfigurationCheckDetails.
            Allowed values for this property are: "SKIP_RECYCLE", "FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type recycle_level: str

        """
        self.swagger_types = {
            'type': 'str',
            'configuration_state': 'str',
            'firmware_bundle_id': 'str',
            'recycle_level': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'configuration_state': 'configurationState',
            'firmware_bundle_id': 'firmwareBundleId',
            'recycle_level': 'recycleLevel'
        }
        self._type = None
        self._configuration_state = None
        self._firmware_bundle_id = None
        self._recycle_level = None

    @property
    def type(self):
        """
        Gets the type of this ComputeHostConfigurationCheckDetails.
        The type of configuration

        Allowed values for this property are: "FIRMWARE", "RECYCLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this ComputeHostConfigurationCheckDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ComputeHostConfigurationCheckDetails.
        The type of configuration


        :param type: The type of this ComputeHostConfigurationCheckDetails.
        :type: str
        """
        allowed_values = ["FIRMWARE", "RECYCLE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def configuration_state(self):
        """
        Gets the configuration_state of this ComputeHostConfigurationCheckDetails.
        The current state of the host configuration. The Host is either |
        CONFORMANT - current state matches the desired configuration
        NON_CONFORMANT - current state does not match the desired configuration
        PRE_APPLYING, APPLYING, CHECKING- transitional states
        UNKNOWN - current state is unknown

        Allowed values for this property are: "CONFORMANT", "NON_CONFORMANT", "CHECKING", "PRE_APPLYING", "APPLYING", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The configuration_state of this ComputeHostConfigurationCheckDetails.
        :rtype: str
        """
        return self._configuration_state

    @configuration_state.setter
    def configuration_state(self, configuration_state):
        """
        Sets the configuration_state of this ComputeHostConfigurationCheckDetails.
        The current state of the host configuration. The Host is either |
        CONFORMANT - current state matches the desired configuration
        NON_CONFORMANT - current state does not match the desired configuration
        PRE_APPLYING, APPLYING, CHECKING- transitional states
        UNKNOWN - current state is unknown


        :param configuration_state: The configuration_state of this ComputeHostConfigurationCheckDetails.
        :type: str
        """
        allowed_values = ["CONFORMANT", "NON_CONFORMANT", "CHECKING", "PRE_APPLYING", "APPLYING", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(configuration_state, allowed_values):
            configuration_state = 'UNKNOWN_ENUM_VALUE'
        self._configuration_state = configuration_state

    @property
    def firmware_bundle_id(self):
        """
        Gets the firmware_bundle_id of this ComputeHostConfigurationCheckDetails.
        The `OCID`__ for the Customer-unique firmware bundle associated with the Host Configuration.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The firmware_bundle_id of this ComputeHostConfigurationCheckDetails.
        :rtype: str
        """
        return self._firmware_bundle_id

    @firmware_bundle_id.setter
    def firmware_bundle_id(self, firmware_bundle_id):
        """
        Sets the firmware_bundle_id of this ComputeHostConfigurationCheckDetails.
        The `OCID`__ for the Customer-unique firmware bundle associated with the Host Configuration.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param firmware_bundle_id: The firmware_bundle_id of this ComputeHostConfigurationCheckDetails.
        :type: str
        """
        self._firmware_bundle_id = firmware_bundle_id

    @property
    def recycle_level(self):
        """
        Gets the recycle_level of this ComputeHostConfigurationCheckDetails.
        Preferred recycle level for hosts associated with the reservation config.
        * `SKIP_RECYCLE` - Skips host wipe.
        * `FULL_RECYCLE` - Does not skip host wipe. This is the default behavior.

        Allowed values for this property are: "SKIP_RECYCLE", "FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The recycle_level of this ComputeHostConfigurationCheckDetails.
        :rtype: str
        """
        return self._recycle_level

    @recycle_level.setter
    def recycle_level(self, recycle_level):
        """
        Sets the recycle_level of this ComputeHostConfigurationCheckDetails.
        Preferred recycle level for hosts associated with the reservation config.
        * `SKIP_RECYCLE` - Skips host wipe.
        * `FULL_RECYCLE` - Does not skip host wipe. This is the default behavior.


        :param recycle_level: The recycle_level of this ComputeHostConfigurationCheckDetails.
        :type: str
        """
        allowed_values = ["SKIP_RECYCLE", "FULL_RECYCLE"]
        if not value_allowed_none_or_none_sentinel(recycle_level, allowed_values):
            recycle_level = 'UNKNOWN_ENUM_VALUE'
        self._recycle_level = recycle_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
