# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceConfigurationInstanceSourceImageFilterDetails(object):
    """
    These are the criteria for selecting an image. This is required if imageId is not specified.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceConfigurationInstanceSourceImageFilterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type compartment_id: str

        :param defined_tags_filter:
            The value to assign to the defined_tags_filter property of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type defined_tags_filter: dict(str, dict(str, object))

        :param operating_system:
            The value to assign to the operating_system property of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type operating_system: str

        :param operating_system_version:
            The value to assign to the operating_system_version property of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type operating_system_version: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'defined_tags_filter': 'dict(str, dict(str, object))',
            'operating_system': 'str',
            'operating_system_version': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'defined_tags_filter': 'definedTagsFilter',
            'operating_system': 'operatingSystem',
            'operating_system_version': 'operatingSystemVersion'
        }
        self._compartment_id = None
        self._defined_tags_filter = None
        self._operating_system = None
        self._operating_system_version = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this InstanceConfigurationInstanceSourceImageFilterDetails.
        The OCID of the compartment containing images to search


        :return: The compartment_id of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this InstanceConfigurationInstanceSourceImageFilterDetails.
        The OCID of the compartment containing images to search


        :param compartment_id: The compartment_id of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags_filter(self):
        """
        Gets the defined_tags_filter of this InstanceConfigurationInstanceSourceImageFilterDetails.
        Filter based on these defined tags. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags_filter of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags_filter

    @defined_tags_filter.setter
    def defined_tags_filter(self, defined_tags_filter):
        """
        Sets the defined_tags_filter of this InstanceConfigurationInstanceSourceImageFilterDetails.
        Filter based on these defined tags. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags_filter: The defined_tags_filter of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags_filter = defined_tags_filter

    @property
    def operating_system(self):
        """
        Gets the operating_system of this InstanceConfigurationInstanceSourceImageFilterDetails.
        The image's operating system.

        Example: `Oracle Linux`


        :return: The operating_system of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :rtype: str
        """
        return self._operating_system

    @operating_system.setter
    def operating_system(self, operating_system):
        """
        Sets the operating_system of this InstanceConfigurationInstanceSourceImageFilterDetails.
        The image's operating system.

        Example: `Oracle Linux`


        :param operating_system: The operating_system of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type: str
        """
        self._operating_system = operating_system

    @property
    def operating_system_version(self):
        """
        Gets the operating_system_version of this InstanceConfigurationInstanceSourceImageFilterDetails.
        The image's operating system version.

        Example: `7.2`


        :return: The operating_system_version of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :rtype: str
        """
        return self._operating_system_version

    @operating_system_version.setter
    def operating_system_version(self, operating_system_version):
        """
        Sets the operating_system_version of this InstanceConfigurationInstanceSourceImageFilterDetails.
        The image's operating system version.

        Example: `7.2`


        :param operating_system_version: The operating_system_version of this InstanceConfigurationInstanceSourceImageFilterDetails.
        :type: str
        """
        self._operating_system_version = operating_system_version

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
