# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class LaunchCreateVolumeDetails(object):
    """
    Define a volume that will be created and attached or attached to an instance on creation.
    """

    #: A constant which can be used with the volume_creation_type property of a LaunchCreateVolumeDetails.
    #: This constant has a value of "ATTRIBUTES"
    VOLUME_CREATION_TYPE_ATTRIBUTES = "ATTRIBUTES"

    def __init__(self, **kwargs):
        """
        Initializes a new LaunchCreateVolumeDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.core.models.LaunchCreateVolumeFromAttributes`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param volume_creation_type:
            The value to assign to the volume_creation_type property of this LaunchCreateVolumeDetails.
            Allowed values for this property are: "ATTRIBUTES"
        :type volume_creation_type: str

        """
        self.swagger_types = {
            'volume_creation_type': 'str'
        }
        self.attribute_map = {
            'volume_creation_type': 'volumeCreationType'
        }
        self._volume_creation_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['volumeCreationType']

        if type == 'ATTRIBUTES':
            return 'LaunchCreateVolumeFromAttributes'
        else:
            return 'LaunchCreateVolumeDetails'

    @property
    def volume_creation_type(self):
        """
        **[Required]** Gets the volume_creation_type of this LaunchCreateVolumeDetails.
        Specifies the method for volume creation.

        Allowed values for this property are: "ATTRIBUTES"


        :return: The volume_creation_type of this LaunchCreateVolumeDetails.
        :rtype: str
        """
        return self._volume_creation_type

    @volume_creation_type.setter
    def volume_creation_type(self, volume_creation_type):
        """
        Sets the volume_creation_type of this LaunchCreateVolumeDetails.
        Specifies the method for volume creation.


        :param volume_creation_type: The volume_creation_type of this LaunchCreateVolumeDetails.
        :type: str
        """
        allowed_values = ["ATTRIBUTES"]
        if not value_allowed_none_or_none_sentinel(volume_creation_type, allowed_values):
            raise ValueError(
                f"Invalid value for `volume_creation_type`, must be None or one of {allowed_values}"
            )
        self._volume_creation_type = volume_creation_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
