# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateComputeGpuMemoryClusterScaleConfig(object):
    """
    Configuration settings for GPU Memory Cluster scaling.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateComputeGpuMemoryClusterScaleConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_upsize_enabled:
            The value to assign to the is_upsize_enabled property of this UpdateComputeGpuMemoryClusterScaleConfig.
        :type is_upsize_enabled: bool

        :param is_downsize_enabled:
            The value to assign to the is_downsize_enabled property of this UpdateComputeGpuMemoryClusterScaleConfig.
        :type is_downsize_enabled: bool

        :param target_size:
            The value to assign to the target_size property of this UpdateComputeGpuMemoryClusterScaleConfig.
        :type target_size: int

        """
        self.swagger_types = {
            'is_upsize_enabled': 'bool',
            'is_downsize_enabled': 'bool',
            'target_size': 'int'
        }
        self.attribute_map = {
            'is_upsize_enabled': 'isUpsizeEnabled',
            'is_downsize_enabled': 'isDownsizeEnabled',
            'target_size': 'targetSize'
        }
        self._is_upsize_enabled = None
        self._is_downsize_enabled = None
        self._target_size = None

    @property
    def is_upsize_enabled(self):
        """
        Gets the is_upsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        Enables upsizing towards the target size.


        :return: The is_upsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        :rtype: bool
        """
        return self._is_upsize_enabled

    @is_upsize_enabled.setter
    def is_upsize_enabled(self, is_upsize_enabled):
        """
        Sets the is_upsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        Enables upsizing towards the target size.


        :param is_upsize_enabled: The is_upsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        :type: bool
        """
        self._is_upsize_enabled = is_upsize_enabled

    @property
    def is_downsize_enabled(self):
        """
        Gets the is_downsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        Enables downsizing towards the target size.


        :return: The is_downsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        :rtype: bool
        """
        return self._is_downsize_enabled

    @is_downsize_enabled.setter
    def is_downsize_enabled(self, is_downsize_enabled):
        """
        Sets the is_downsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        Enables downsizing towards the target size.


        :param is_downsize_enabled: The is_downsize_enabled of this UpdateComputeGpuMemoryClusterScaleConfig.
        :type: bool
        """
        self._is_downsize_enabled = is_downsize_enabled

    @property
    def target_size(self):
        """
        Gets the target_size of this UpdateComputeGpuMemoryClusterScaleConfig.
        The configured target size for the GPU Memory cluster.


        :return: The target_size of this UpdateComputeGpuMemoryClusterScaleConfig.
        :rtype: int
        """
        return self._target_size

    @target_size.setter
    def target_size(self, target_size):
        """
        Sets the target_size of this UpdateComputeGpuMemoryClusterScaleConfig.
        The configured target size for the GPU Memory cluster.


        :param target_size: The target_size of this UpdateComputeGpuMemoryClusterScaleConfig.
        :type: int
        """
        self._target_size = target_size

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
