# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AuditProfileDimensions(object):
    """
    Details of aggregation dimensions used for summarizing audit profiles.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AuditProfileDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_paid_usage_enabled:
            The value to assign to the is_paid_usage_enabled property of this AuditProfileDimensions.
        :type is_paid_usage_enabled: bool

        :param target_type:
            The value to assign to the target_type property of this AuditProfileDimensions.
        :type target_type: str

        :param online_months_source:
            The value to assign to the online_months_source property of this AuditProfileDimensions.
        :type online_months_source: str

        :param offline_months_source:
            The value to assign to the offline_months_source property of this AuditProfileDimensions.
        :type offline_months_source: str

        :param paid_usage_source:
            The value to assign to the paid_usage_source property of this AuditProfileDimensions.
        :type paid_usage_source: str

        """
        self.swagger_types = {
            'is_paid_usage_enabled': 'bool',
            'target_type': 'str',
            'online_months_source': 'str',
            'offline_months_source': 'str',
            'paid_usage_source': 'str'
        }
        self.attribute_map = {
            'is_paid_usage_enabled': 'isPaidUsageEnabled',
            'target_type': 'targetType',
            'online_months_source': 'onlineMonthsSource',
            'offline_months_source': 'offlineMonthsSource',
            'paid_usage_source': 'paidUsageSource'
        }
        self._is_paid_usage_enabled = None
        self._target_type = None
        self._online_months_source = None
        self._offline_months_source = None
        self._paid_usage_source = None

    @property
    def is_paid_usage_enabled(self):
        """
        Gets the is_paid_usage_enabled of this AuditProfileDimensions.
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. The default value is inherited from the global settings.
        You can change at the global level or at the target level.


        :return: The is_paid_usage_enabled of this AuditProfileDimensions.
        :rtype: bool
        """
        return self._is_paid_usage_enabled

    @is_paid_usage_enabled.setter
    def is_paid_usage_enabled(self, is_paid_usage_enabled):
        """
        Sets the is_paid_usage_enabled of this AuditProfileDimensions.
        Indicates if you want to continue collecting audit records beyond the free limit of one million audit records per month per target database,
        potentially incurring additional charges. The default value is inherited from the global settings.
        You can change at the global level or at the target level.


        :param is_paid_usage_enabled: The is_paid_usage_enabled of this AuditProfileDimensions.
        :type: bool
        """
        self._is_paid_usage_enabled = is_paid_usage_enabled

    @property
    def target_type(self):
        """
        Gets the target_type of this AuditProfileDimensions.
        The resource type that is represented by the audit profile.


        :return: The target_type of this AuditProfileDimensions.
        :rtype: str
        """
        return self._target_type

    @target_type.setter
    def target_type(self, target_type):
        """
        Sets the target_type of this AuditProfileDimensions.
        The resource type that is represented by the audit profile.


        :param target_type: The target_type of this AuditProfileDimensions.
        :type: str
        """
        self._target_type = target_type

    @property
    def online_months_source(self):
        """
        Gets the online_months_source of this AuditProfileDimensions.
        The name or the OCID of the resource from which the online month retention setting is sourced. For example a target database group OCID or global.


        :return: The online_months_source of this AuditProfileDimensions.
        :rtype: str
        """
        return self._online_months_source

    @online_months_source.setter
    def online_months_source(self, online_months_source):
        """
        Sets the online_months_source of this AuditProfileDimensions.
        The name or the OCID of the resource from which the online month retention setting is sourced. For example a target database group OCID or global.


        :param online_months_source: The online_months_source of this AuditProfileDimensions.
        :type: str
        """
        self._online_months_source = online_months_source

    @property
    def offline_months_source(self):
        """
        Gets the offline_months_source of this AuditProfileDimensions.
        The name or the OCID of the resource from which the offline month retention setting is sourced. For example a target database group OCID or global.


        :return: The offline_months_source of this AuditProfileDimensions.
        :rtype: str
        """
        return self._offline_months_source

    @offline_months_source.setter
    def offline_months_source(self, offline_months_source):
        """
        Sets the offline_months_source of this AuditProfileDimensions.
        The name or the OCID of the resource from which the offline month retention setting is sourced. For example a target database group OCID or global.


        :param offline_months_source: The offline_months_source of this AuditProfileDimensions.
        :type: str
        """
        self._offline_months_source = offline_months_source

    @property
    def paid_usage_source(self):
        """
        Gets the paid_usage_source of this AuditProfileDimensions.
        The name or the OCID of the resource from which the paid usage setting is sourced. For example a target database group OCID or global.


        :return: The paid_usage_source of this AuditProfileDimensions.
        :rtype: str
        """
        return self._paid_usage_source

    @paid_usage_source.setter
    def paid_usage_source(self, paid_usage_source):
        """
        Sets the paid_usage_source of this AuditProfileDimensions.
        The name or the OCID of the resource from which the paid usage setting is sourced. For example a target database group OCID or global.


        :param paid_usage_source: The paid_usage_source of this AuditProfileDimensions.
        :type: str
        """
        self._paid_usage_source = paid_usage_source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
