# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlCollectionLogDimensions(object):
    """
    The dimensions available for SQL collection analytics.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SqlCollectionLogDimensions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param client_ip:
            The value to assign to the client_ip property of this SqlCollectionLogDimensions.
        :type client_ip: str

        :param client_os_user_name:
            The value to assign to the client_os_user_name property of this SqlCollectionLogDimensions.
        :type client_os_user_name: str

        :param client_program:
            The value to assign to the client_program property of this SqlCollectionLogDimensions.
        :type client_program: str

        """
        self.swagger_types = {
            'client_ip': 'str',
            'client_os_user_name': 'str',
            'client_program': 'str'
        }
        self.attribute_map = {
            'client_ip': 'clientIp',
            'client_os_user_name': 'clientOsUserName',
            'client_program': 'clientProgram'
        }
        self._client_ip = None
        self._client_os_user_name = None
        self._client_program = None

    @property
    def client_ip(self):
        """
        Gets the client_ip of this SqlCollectionLogDimensions.
        The IP addresses for the SQL collection.


        :return: The client_ip of this SqlCollectionLogDimensions.
        :rtype: str
        """
        return self._client_ip

    @client_ip.setter
    def client_ip(self, client_ip):
        """
        Sets the client_ip of this SqlCollectionLogDimensions.
        The IP addresses for the SQL collection.


        :param client_ip: The client_ip of this SqlCollectionLogDimensions.
        :type: str
        """
        self._client_ip = client_ip

    @property
    def client_os_user_name(self):
        """
        Gets the client_os_user_name of this SqlCollectionLogDimensions.
        The operating system user names for the SQL collection.


        :return: The client_os_user_name of this SqlCollectionLogDimensions.
        :rtype: str
        """
        return self._client_os_user_name

    @client_os_user_name.setter
    def client_os_user_name(self, client_os_user_name):
        """
        Sets the client_os_user_name of this SqlCollectionLogDimensions.
        The operating system user names for the SQL collection.


        :param client_os_user_name: The client_os_user_name of this SqlCollectionLogDimensions.
        :type: str
        """
        self._client_os_user_name = client_os_user_name

    @property
    def client_program(self):
        """
        Gets the client_program of this SqlCollectionLogDimensions.
        The allowed client programs for the SQL collection.


        :return: The client_program of this SqlCollectionLogDimensions.
        :rtype: str
        """
        return self._client_program

    @client_program.setter
    def client_program(self, client_program):
        """
        Sets the client_program of this SqlCollectionLogDimensions.
        The allowed client programs for the SQL collection.


        :param client_program: The client_program of this SqlCollectionLogDimensions.
        :type: str
        """
        self._client_program = client_program

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
