# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TemplateBaselineDiffs(object):
    """
    Results of the comparison of an item between two security assessments.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TemplateBaselineDiffs object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param baseline:
            The value to assign to the baseline property of this TemplateBaselineDiffs.
        :type baseline: oci.data_safe.models.Finding

        :param targets:
            The value to assign to the targets property of this TemplateBaselineDiffs.
        :type targets: list[oci.data_safe.models.TemplateBaselineDiffsPerTarget]

        """
        self.swagger_types = {
            'baseline': 'Finding',
            'targets': 'list[TemplateBaselineDiffsPerTarget]'
        }
        self.attribute_map = {
            'baseline': 'baseline',
            'targets': 'targets'
        }
        self._baseline = None
        self._targets = None

    @property
    def baseline(self):
        """
        Gets the baseline of this TemplateBaselineDiffs.

        :return: The baseline of this TemplateBaselineDiffs.
        :rtype: oci.data_safe.models.Finding
        """
        return self._baseline

    @baseline.setter
    def baseline(self, baseline):
        """
        Sets the baseline of this TemplateBaselineDiffs.

        :param baseline: The baseline of this TemplateBaselineDiffs.
        :type: oci.data_safe.models.Finding
        """
        self._baseline = baseline

    @property
    def targets(self):
        """
        Gets the targets of this TemplateBaselineDiffs.
        A target-based comparison between two security assessments.


        :return: The targets of this TemplateBaselineDiffs.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffsPerTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this TemplateBaselineDiffs.
        A target-based comparison between two security assessments.


        :param targets: The targets of this TemplateBaselineDiffs.
        :type: list[oci.data_safe.models.TemplateBaselineDiffsPerTarget]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
