# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .schedule_http_action_details import ScheduleHttpActionDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InvokeMlApplicationProviderTriggerScheduleActionDetails(ScheduleHttpActionDetails):
    """
    invoke ml application trigger details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InvokeMlApplicationProviderTriggerScheduleActionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.InvokeMlApplicationProviderTriggerScheduleActionDetails.http_action_type` attribute
        of this class is ``INVOKE_ML_APPLICATION_PROVIDER_TRIGGER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param http_action_type:
            The value to assign to the http_action_type property of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
            Allowed values for this property are: "CREATE_JOB_RUN", "CREATE_PIPELINE_RUN", "INVOKE_ML_APPLICATION_PROVIDER_TRIGGER"
        :type http_action_type: str

        :param ml_application_instance_view_id:
            The value to assign to the ml_application_instance_view_id property of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        :type ml_application_instance_view_id: str

        :param trigger_ml_application_instance_view_flow_details:
            The value to assign to the trigger_ml_application_instance_view_flow_details property of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        :type trigger_ml_application_instance_view_flow_details: oci.data_science.models.TriggerMlApplicationInstanceViewFlowDetails

        """
        self.swagger_types = {
            'http_action_type': 'str',
            'ml_application_instance_view_id': 'str',
            'trigger_ml_application_instance_view_flow_details': 'TriggerMlApplicationInstanceViewFlowDetails'
        }
        self.attribute_map = {
            'http_action_type': 'httpActionType',
            'ml_application_instance_view_id': 'mlApplicationInstanceViewId',
            'trigger_ml_application_instance_view_flow_details': 'triggerMlApplicationInstanceViewFlowDetails'
        }
        self._http_action_type = None
        self._ml_application_instance_view_id = None
        self._trigger_ml_application_instance_view_flow_details = None
        self._http_action_type = 'INVOKE_ML_APPLICATION_PROVIDER_TRIGGER'

    @property
    def ml_application_instance_view_id(self):
        """
        **[Required]** Gets the ml_application_instance_view_id of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        The `OCID`__ of the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The ml_application_instance_view_id of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        :rtype: str
        """
        return self._ml_application_instance_view_id

    @ml_application_instance_view_id.setter
    def ml_application_instance_view_id(self, ml_application_instance_view_id):
        """
        Sets the ml_application_instance_view_id of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        The `OCID`__ of the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param ml_application_instance_view_id: The ml_application_instance_view_id of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        :type: str
        """
        self._ml_application_instance_view_id = ml_application_instance_view_id

    @property
    def trigger_ml_application_instance_view_flow_details(self):
        """
        **[Required]** Gets the trigger_ml_application_instance_view_flow_details of this InvokeMlApplicationProviderTriggerScheduleActionDetails.

        :return: The trigger_ml_application_instance_view_flow_details of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        :rtype: oci.data_science.models.TriggerMlApplicationInstanceViewFlowDetails
        """
        return self._trigger_ml_application_instance_view_flow_details

    @trigger_ml_application_instance_view_flow_details.setter
    def trigger_ml_application_instance_view_flow_details(self, trigger_ml_application_instance_view_flow_details):
        """
        Sets the trigger_ml_application_instance_view_flow_details of this InvokeMlApplicationProviderTriggerScheduleActionDetails.

        :param trigger_ml_application_instance_view_flow_details: The trigger_ml_application_instance_view_flow_details of this InvokeMlApplicationProviderTriggerScheduleActionDetails.
        :type: oci.data_science.models.TriggerMlApplicationInstanceViewFlowDetails
        """
        self._trigger_ml_application_instance_view_flow_details = trigger_ml_application_instance_view_flow_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
