# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobNetworkConfiguration(object):
    """
    The job network configuration details
    """

    #: A constant which can be used with the job_network_type property of a JobNetworkConfiguration.
    #: This constant has a value of "CUSTOM_NETWORK"
    JOB_NETWORK_TYPE_CUSTOM_NETWORK = "CUSTOM_NETWORK"

    #: A constant which can be used with the job_network_type property of a JobNetworkConfiguration.
    #: This constant has a value of "DEFAULT_NETWORK"
    JOB_NETWORK_TYPE_DEFAULT_NETWORK = "DEFAULT_NETWORK"

    def __init__(self, **kwargs):
        """
        Initializes a new JobNetworkConfiguration object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.data_science.models.JobCustomNetworkConfiguration`
        * :class:`~oci.data_science.models.JobDefaultNetworkConfiguration`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param job_network_type:
            The value to assign to the job_network_type property of this JobNetworkConfiguration.
            Allowed values for this property are: "CUSTOM_NETWORK", "DEFAULT_NETWORK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type job_network_type: str

        """
        self.swagger_types = {
            'job_network_type': 'str'
        }
        self.attribute_map = {
            'job_network_type': 'jobNetworkType'
        }
        self._job_network_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['jobNetworkType']

        if type == 'CUSTOM_NETWORK':
            return 'JobCustomNetworkConfiguration'

        if type == 'DEFAULT_NETWORK':
            return 'JobDefaultNetworkConfiguration'
        else:
            return 'JobNetworkConfiguration'

    @property
    def job_network_type(self):
        """
        **[Required]** Gets the job_network_type of this JobNetworkConfiguration.
        job network type

        Allowed values for this property are: "CUSTOM_NETWORK", "DEFAULT_NETWORK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The job_network_type of this JobNetworkConfiguration.
        :rtype: str
        """
        return self._job_network_type

    @job_network_type.setter
    def job_network_type(self, job_network_type):
        """
        Sets the job_network_type of this JobNetworkConfiguration.
        job network type


        :param job_network_type: The job_network_type of this JobNetworkConfiguration.
        :type: str
        """
        allowed_values = ["CUSTOM_NETWORK", "DEFAULT_NETWORK"]
        if not value_allowed_none_or_none_sentinel(job_network_type, allowed_values):
            job_network_type = 'UNKNOWN_ENUM_VALUE'
        self._job_network_type = job_network_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
